/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.model;

import java.io.File;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.s3.ResumeToken;
import software.amazon.awssdk.services.s3.internal.crt.S3MetaRequestPauseObservable;
import software.amazon.awssdk.transfer.s3.model.CompletedFileUpload;
import software.amazon.awssdk.transfer.s3.model.FileUpload;
import software.amazon.awssdk.transfer.s3.model.ResumableFileUpload;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.awssdk.transfer.s3.progress.TransferProgress;
import software.amazon.awssdk.utils.Lazy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class CrtFileUpload
implements FileUpload {
    private final Lazy<ResumableFileUpload> resumableFileUpload;
    private final CompletableFuture<CompletedFileUpload> completionFuture;
    private final TransferProgress progress;
    private final UploadFileRequest request;
    private final S3MetaRequestPauseObservable observable;

    public CrtFileUpload(CompletableFuture<CompletedFileUpload> completionFuture, TransferProgress progress, S3MetaRequestPauseObservable observable, UploadFileRequest request) {
        this.completionFuture = (CompletableFuture)Validate.paramNotNull(completionFuture, (String)"completionFuture");
        this.progress = (TransferProgress)Validate.paramNotNull((Object)progress, (String)"progress");
        this.observable = (S3MetaRequestPauseObservable)Validate.paramNotNull((Object)observable, (String)"observable");
        this.request = (UploadFileRequest)Validate.paramNotNull((Object)request, (String)"request");
        this.resumableFileUpload = new Lazy(this::doPause);
    }

    @Override
    public ResumableFileUpload pause() {
        return (ResumableFileUpload)this.resumableFileUpload.getValue();
    }

    private ResumableFileUpload doPause() {
        ResumeToken token;
        Instant fileLastModified;
        File sourceFile;
        block4: {
            sourceFile = this.request.source().toFile();
            if (this.completionFuture.isDone()) {
                Instant fileLastModified2 = Instant.ofEpochMilli(sourceFile.lastModified());
                return (ResumableFileUpload)ResumableFileUpload.builder().fileLastModified(fileLastModified2).fileLength(sourceFile.length()).uploadFileRequest(this.request).build();
            }
            fileLastModified = Instant.ofEpochMilli(sourceFile.lastModified());
            token = null;
            try {
                token = this.observable.pause();
            }
            catch (CrtRuntimeException exception) {
                if (exception.errorName.equals("AWS_ERROR_UNSUPPORTED_OPERATION")) break block4;
                throw exception;
            }
        }
        this.completionFuture.cancel(true);
        if (token == null) {
            return (ResumableFileUpload)ResumableFileUpload.builder().fileLastModified(fileLastModified).fileLength(sourceFile.length()).uploadFileRequest(this.request).build();
        }
        return (ResumableFileUpload)ResumableFileUpload.builder().multipartUploadId(token.getUploadId()).totalParts(token.getTotalNumParts()).transferredParts(token.getNumPartsCompleted()).partSizeInBytes(token.getPartSize()).fileLastModified(fileLastModified).fileLength(sourceFile.length()).uploadFileRequest(this.request).build();
    }

    @Override
    public CompletableFuture<CompletedFileUpload> completionFuture() {
        return this.completionFuture;
    }

    @Override
    public TransferProgress progress() {
        return this.progress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrtFileUpload that = (CrtFileUpload)o;
        if (!this.resumableFileUpload.equals(that.resumableFileUpload)) {
            return false;
        }
        if (!this.completionFuture.equals(that.completionFuture)) {
            return false;
        }
        if (!this.progress.equals(that.progress)) {
            return false;
        }
        if (!this.request.equals(that.request)) {
            return false;
        }
        return this.observable == that.observable;
    }

    public int hashCode() {
        int result = this.resumableFileUpload.hashCode();
        result = 31 * result + this.completionFuture.hashCode();
        result = 31 * result + this.progress.hashCode();
        result = 31 * result + this.request.hashCode();
        result = 31 * result + this.observable.hashCode();
        return result;
    }

    public String toString() {
        return ToString.builder((String)"CrtFileUpload").add("completionFuture", this.completionFuture).add("progress", (Object)this.progress).add("request", (Object)this.request).build();
    }
}

