/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventnotifications.s3.model;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.utils.ToString;

@SdkPublicApi
public class S3Object {
    private final String key;
    private final Long size;
    private final String eTag;
    private final String versionId;
    private final String sequencer;

    public S3Object(String key, Long size, String eTag, String versionId, String sequencer) {
        this.key = key;
        this.size = size;
        this.eTag = eTag;
        this.versionId = versionId;
        this.sequencer = sequencer;
    }

    public String getKey() {
        return this.key;
    }

    public String getUrlDecodedKey() {
        try {
            return URLDecoder.decode(this.getKey(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Long getSizeAsLong() {
        return this.size;
    }

    public String getETag() {
        return this.eTag;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getSequencer() {
        return this.sequencer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3Object s3Object = (S3Object)o;
        if (!Objects.equals(this.key, s3Object.key)) {
            return false;
        }
        if (!Objects.equals(this.size, s3Object.size)) {
            return false;
        }
        if (!Objects.equals(this.eTag, s3Object.eTag)) {
            return false;
        }
        if (!Objects.equals(this.versionId, s3Object.versionId)) {
            return false;
        }
        return Objects.equals(this.sequencer, s3Object.sequencer);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
        result = 31 * result + (this.eTag != null ? this.eTag.hashCode() : 0);
        result = 31 * result + (this.versionId != null ? this.versionId.hashCode() : 0);
        result = 31 * result + (this.sequencer != null ? this.sequencer.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"S3Object").add("key", (Object)this.key).add("size", (Object)this.size).add("eTag", (Object)this.eTag).add("versionId", (Object)this.versionId).add("sequencer", (Object)this.sequencer).build();
    }
}

