/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rum.model.AppMonitorConfiguration;
import software.amazon.awssdk.services.rum.model.AppMonitorDomainListCopier;
import software.amazon.awssdk.services.rum.model.CustomEvents;
import software.amazon.awssdk.services.rum.model.DeobfuscationConfiguration;
import software.amazon.awssdk.services.rum.model.RumRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAppMonitorRequest
extends RumRequest
implements ToCopyableBuilder<Builder, UpdateAppMonitorRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateAppMonitorRequest.getter(UpdateAppMonitorRequest::name)).setter(UpdateAppMonitorRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(UpdateAppMonitorRequest.getter(UpdateAppMonitorRequest::domain)).setter(UpdateAppMonitorRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<List<String>> DOMAIN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainList").getter(UpdateAppMonitorRequest.getter(UpdateAppMonitorRequest::domainList)).setter(UpdateAppMonitorRequest.setter(Builder::domainList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AppMonitorConfiguration> APP_MONITOR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppMonitorConfiguration").getter(UpdateAppMonitorRequest.getter(UpdateAppMonitorRequest::appMonitorConfiguration)).setter(UpdateAppMonitorRequest.setter(Builder::appMonitorConfiguration)).constructor(AppMonitorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppMonitorConfiguration").build()}).build();
    private static final SdkField<Boolean> CW_LOG_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CwLogEnabled").getter(UpdateAppMonitorRequest.getter(UpdateAppMonitorRequest::cwLogEnabled)).setter(UpdateAppMonitorRequest.setter(Builder::cwLogEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CwLogEnabled").build()}).build();
    private static final SdkField<CustomEvents> CUSTOM_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomEvents").getter(UpdateAppMonitorRequest.getter(UpdateAppMonitorRequest::customEvents)).setter(UpdateAppMonitorRequest.setter(Builder::customEvents)).constructor(CustomEvents::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEvents").build()}).build();
    private static final SdkField<DeobfuscationConfiguration> DEOBFUSCATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeobfuscationConfiguration").getter(UpdateAppMonitorRequest.getter(UpdateAppMonitorRequest::deobfuscationConfiguration)).setter(UpdateAppMonitorRequest.setter(Builder::deobfuscationConfiguration)).constructor(DeobfuscationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeobfuscationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DOMAIN_FIELD, DOMAIN_LIST_FIELD, APP_MONITOR_CONFIGURATION_FIELD, CW_LOG_ENABLED_FIELD, CUSTOM_EVENTS_FIELD, DEOBFUSCATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAppMonitorRequest.memberNameToFieldInitializer();
    private final String name;
    private final String domain;
    private final List<String> domainList;
    private final AppMonitorConfiguration appMonitorConfiguration;
    private final Boolean cwLogEnabled;
    private final CustomEvents customEvents;
    private final DeobfuscationConfiguration deobfuscationConfiguration;

    private UpdateAppMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.domain = builder.domain;
        this.domainList = builder.domainList;
        this.appMonitorConfiguration = builder.appMonitorConfiguration;
        this.cwLogEnabled = builder.cwLogEnabled;
        this.customEvents = builder.customEvents;
        this.deobfuscationConfiguration = builder.deobfuscationConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final String domain() {
        return this.domain;
    }

    public final boolean hasDomainList() {
        return this.domainList != null && !(this.domainList instanceof SdkAutoConstructList);
    }

    public final List<String> domainList() {
        return this.domainList;
    }

    public final AppMonitorConfiguration appMonitorConfiguration() {
        return this.appMonitorConfiguration;
    }

    public final Boolean cwLogEnabled() {
        return this.cwLogEnabled;
    }

    public final CustomEvents customEvents() {
        return this.customEvents;
    }

    public final DeobfuscationConfiguration deobfuscationConfiguration() {
        return this.deobfuscationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainList() ? this.domainList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.appMonitorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cwLogEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.customEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.deobfuscationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppMonitorRequest)) {
            return false;
        }
        UpdateAppMonitorRequest other = (UpdateAppMonitorRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.domain(), other.domain()) && this.hasDomainList() == other.hasDomainList() && Objects.equals(this.domainList(), other.domainList()) && Objects.equals(this.appMonitorConfiguration(), other.appMonitorConfiguration()) && Objects.equals(this.cwLogEnabled(), other.cwLogEnabled()) && Objects.equals(this.customEvents(), other.customEvents()) && Objects.equals(this.deobfuscationConfiguration(), other.deobfuscationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAppMonitorRequest").add("Name", (Object)this.name()).add("Domain", (Object)this.domain()).add("DomainList", this.hasDomainList() ? this.domainList() : null).add("AppMonitorConfiguration", (Object)this.appMonitorConfiguration()).add("CwLogEnabled", (Object)this.cwLogEnabled()).add("CustomEvents", (Object)this.customEvents()).add("DeobfuscationConfiguration", (Object)this.deobfuscationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "DomainList": {
                return Optional.ofNullable(clazz.cast(this.domainList()));
            }
            case "AppMonitorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.appMonitorConfiguration()));
            }
            case "CwLogEnabled": {
                return Optional.ofNullable(clazz.cast(this.cwLogEnabled()));
            }
            case "CustomEvents": {
                return Optional.ofNullable(clazz.cast(this.customEvents()));
            }
            case "DeobfuscationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deobfuscationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("DomainList", DOMAIN_LIST_FIELD);
        map.put("AppMonitorConfiguration", APP_MONITOR_CONFIGURATION_FIELD);
        map.put("CwLogEnabled", CW_LOG_ENABLED_FIELD);
        map.put("CustomEvents", CUSTOM_EVENTS_FIELD);
        map.put("DeobfuscationConfiguration", DEOBFUSCATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppMonitorRequest, T> g) {
        return obj -> g.apply((UpdateAppMonitorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RumRequest.BuilderImpl
    implements Builder {
        private String name;
        private String domain;
        private List<String> domainList = DefaultSdkAutoConstructList.getInstance();
        private AppMonitorConfiguration appMonitorConfiguration;
        private Boolean cwLogEnabled;
        private CustomEvents customEvents;
        private DeobfuscationConfiguration deobfuscationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppMonitorRequest model) {
            super(model);
            this.name(model.name);
            this.domain(model.domain);
            this.domainList(model.domainList);
            this.appMonitorConfiguration(model.appMonitorConfiguration);
            this.cwLogEnabled(model.cwLogEnabled);
            this.customEvents(model.customEvents);
            this.deobfuscationConfiguration(model.deobfuscationConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final Collection<String> getDomainList() {
            if (this.domainList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domainList;
        }

        public final void setDomainList(Collection<String> domainList) {
            this.domainList = AppMonitorDomainListCopier.copy(domainList);
        }

        @Override
        public final Builder domainList(Collection<String> domainList) {
            this.domainList = AppMonitorDomainListCopier.copy(domainList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainList(String ... domainList) {
            this.domainList(Arrays.asList(domainList));
            return this;
        }

        public final AppMonitorConfiguration.Builder getAppMonitorConfiguration() {
            return this.appMonitorConfiguration != null ? this.appMonitorConfiguration.toBuilder() : null;
        }

        public final void setAppMonitorConfiguration(AppMonitorConfiguration.BuilderImpl appMonitorConfiguration) {
            this.appMonitorConfiguration = appMonitorConfiguration != null ? appMonitorConfiguration.build() : null;
        }

        @Override
        public final Builder appMonitorConfiguration(AppMonitorConfiguration appMonitorConfiguration) {
            this.appMonitorConfiguration = appMonitorConfiguration;
            return this;
        }

        public final Boolean getCwLogEnabled() {
            return this.cwLogEnabled;
        }

        public final void setCwLogEnabled(Boolean cwLogEnabled) {
            this.cwLogEnabled = cwLogEnabled;
        }

        @Override
        public final Builder cwLogEnabled(Boolean cwLogEnabled) {
            this.cwLogEnabled = cwLogEnabled;
            return this;
        }

        public final CustomEvents.Builder getCustomEvents() {
            return this.customEvents != null ? this.customEvents.toBuilder() : null;
        }

        public final void setCustomEvents(CustomEvents.BuilderImpl customEvents) {
            this.customEvents = customEvents != null ? customEvents.build() : null;
        }

        @Override
        public final Builder customEvents(CustomEvents customEvents) {
            this.customEvents = customEvents;
            return this;
        }

        public final DeobfuscationConfiguration.Builder getDeobfuscationConfiguration() {
            return this.deobfuscationConfiguration != null ? this.deobfuscationConfiguration.toBuilder() : null;
        }

        public final void setDeobfuscationConfiguration(DeobfuscationConfiguration.BuilderImpl deobfuscationConfiguration) {
            this.deobfuscationConfiguration = deobfuscationConfiguration != null ? deobfuscationConfiguration.build() : null;
        }

        @Override
        public final Builder deobfuscationConfiguration(DeobfuscationConfiguration deobfuscationConfiguration) {
            this.deobfuscationConfiguration = deobfuscationConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppMonitorRequest build() {
            return new UpdateAppMonitorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RumRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAppMonitorRequest> {
        public Builder name(String var1);

        public Builder domain(String var1);

        public Builder domainList(Collection<String> var1);

        public Builder domainList(String ... var1);

        public Builder appMonitorConfiguration(AppMonitorConfiguration var1);

        default public Builder appMonitorConfiguration(Consumer<AppMonitorConfiguration.Builder> appMonitorConfiguration) {
            return this.appMonitorConfiguration((AppMonitorConfiguration)((AppMonitorConfiguration.Builder)AppMonitorConfiguration.builder().applyMutation(appMonitorConfiguration)).build());
        }

        public Builder cwLogEnabled(Boolean var1);

        public Builder customEvents(CustomEvents var1);

        default public Builder customEvents(Consumer<CustomEvents.Builder> customEvents) {
            return this.customEvents((CustomEvents)((CustomEvents.Builder)CustomEvents.builder().applyMutation(customEvents)).build());
        }

        public Builder deobfuscationConfiguration(DeobfuscationConfiguration var1);

        default public Builder deobfuscationConfiguration(Consumer<DeobfuscationConfiguration.Builder> deobfuscationConfiguration) {
            return this.deobfuscationConfiguration((DeobfuscationConfiguration)((DeobfuscationConfiguration.Builder)DeobfuscationConfiguration.builder().applyMutation(deobfuscationConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

