/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rum.model.AppMonitorSummary;
import software.amazon.awssdk.services.rum.model.AppMonitorSummaryListCopier;
import software.amazon.awssdk.services.rum.model.RumResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppMonitorsResponse
extends RumResponse
implements ToCopyableBuilder<Builder, ListAppMonitorsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAppMonitorsResponse.getter(ListAppMonitorsResponse::nextToken)).setter(ListAppMonitorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<AppMonitorSummary>> APP_MONITOR_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppMonitorSummaries").getter(ListAppMonitorsResponse.getter(ListAppMonitorsResponse::appMonitorSummaries)).setter(ListAppMonitorsResponse.setter(Builder::appMonitorSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppMonitorSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppMonitorSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, APP_MONITOR_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAppMonitorsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<AppMonitorSummary> appMonitorSummaries;

    private ListAppMonitorsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.appMonitorSummaries = builder.appMonitorSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAppMonitorSummaries() {
        return this.appMonitorSummaries != null && !(this.appMonitorSummaries instanceof SdkAutoConstructList);
    }

    public final List<AppMonitorSummary> appMonitorSummaries() {
        return this.appMonitorSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppMonitorSummaries() ? this.appMonitorSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppMonitorsResponse)) {
            return false;
        }
        ListAppMonitorsResponse other = (ListAppMonitorsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAppMonitorSummaries() == other.hasAppMonitorSummaries() && Objects.equals(this.appMonitorSummaries(), other.appMonitorSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppMonitorsResponse").add("NextToken", (Object)this.nextToken()).add("AppMonitorSummaries", this.hasAppMonitorSummaries() ? this.appMonitorSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "AppMonitorSummaries": {
                return Optional.ofNullable(clazz.cast(this.appMonitorSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("AppMonitorSummaries", APP_MONITOR_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAppMonitorsResponse, T> g) {
        return obj -> g.apply((ListAppMonitorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RumResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<AppMonitorSummary> appMonitorSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppMonitorsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.appMonitorSummaries(model.appMonitorSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AppMonitorSummary.Builder> getAppMonitorSummaries() {
            List<AppMonitorSummary.Builder> result = AppMonitorSummaryListCopier.copyToBuilder(this.appMonitorSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppMonitorSummaries(Collection<AppMonitorSummary.BuilderImpl> appMonitorSummaries) {
            this.appMonitorSummaries = AppMonitorSummaryListCopier.copyFromBuilder(appMonitorSummaries);
        }

        @Override
        public final Builder appMonitorSummaries(Collection<AppMonitorSummary> appMonitorSummaries) {
            this.appMonitorSummaries = AppMonitorSummaryListCopier.copy(appMonitorSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appMonitorSummaries(AppMonitorSummary ... appMonitorSummaries) {
            this.appMonitorSummaries(Arrays.asList(appMonitorSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appMonitorSummaries(Consumer<AppMonitorSummary.Builder> ... appMonitorSummaries) {
            this.appMonitorSummaries(Stream.of(appMonitorSummaries).map(c -> (AppMonitorSummary)((AppMonitorSummary.Builder)AppMonitorSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAppMonitorsResponse build() {
            return new ListAppMonitorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RumResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppMonitorsResponse> {
        public Builder nextToken(String var1);

        public Builder appMonitorSummaries(Collection<AppMonitorSummary> var1);

        public Builder appMonitorSummaries(AppMonitorSummary ... var1);

        public Builder appMonitorSummaries(Consumer<AppMonitorSummary.Builder> ... var1);
    }
}

