/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rum.model.FavoritePagesCopier;
import software.amazon.awssdk.services.rum.model.PagesCopier;
import software.amazon.awssdk.services.rum.model.TelemetriesCopier;
import software.amazon.awssdk.services.rum.model.Telemetry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppMonitorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppMonitorConfiguration> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolId").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::identityPoolId)).setter(AppMonitorConfiguration.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()}).build();
    private static final SdkField<List<String>> EXCLUDED_PAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedPages").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::excludedPages)).setter(AppMonitorConfiguration.setter(Builder::excludedPages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedPages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUDED_PAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludedPages").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::includedPages)).setter(AppMonitorConfiguration.setter(Builder::includedPages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedPages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FAVORITE_PAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FavoritePages").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::favoritePages)).setter(AppMonitorConfiguration.setter(Builder::favoritePages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FavoritePages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> SESSION_SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SessionSampleRate").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::sessionSampleRate)).setter(AppMonitorConfiguration.setter(Builder::sessionSampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionSampleRate").build()}).build();
    private static final SdkField<String> GUEST_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GuestRoleArn").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::guestRoleArn)).setter(AppMonitorConfiguration.setter(Builder::guestRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuestRoleArn").build()}).build();
    private static final SdkField<Boolean> ALLOW_COOKIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowCookies").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::allowCookies)).setter(AppMonitorConfiguration.setter(Builder::allowCookies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowCookies").build()}).build();
    private static final SdkField<List<String>> TELEMETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Telemetries").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::telemetriesAsStrings)).setter(AppMonitorConfiguration.setter(Builder::telemetriesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Telemetries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_X_RAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableXRay").getter(AppMonitorConfiguration.getter(AppMonitorConfiguration::enableXRay)).setter(AppMonitorConfiguration.setter(Builder::enableXRay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableXRay").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD, EXCLUDED_PAGES_FIELD, INCLUDED_PAGES_FIELD, FAVORITE_PAGES_FIELD, SESSION_SAMPLE_RATE_FIELD, GUEST_ROLE_ARN_FIELD, ALLOW_COOKIES_FIELD, TELEMETRIES_FIELD, ENABLE_X_RAY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppMonitorConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String identityPoolId;
    private final List<String> excludedPages;
    private final List<String> includedPages;
    private final List<String> favoritePages;
    private final Double sessionSampleRate;
    private final String guestRoleArn;
    private final Boolean allowCookies;
    private final List<String> telemetries;
    private final Boolean enableXRay;

    private AppMonitorConfiguration(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.excludedPages = builder.excludedPages;
        this.includedPages = builder.includedPages;
        this.favoritePages = builder.favoritePages;
        this.sessionSampleRate = builder.sessionSampleRate;
        this.guestRoleArn = builder.guestRoleArn;
        this.allowCookies = builder.allowCookies;
        this.telemetries = builder.telemetries;
        this.enableXRay = builder.enableXRay;
    }

    public final String identityPoolId() {
        return this.identityPoolId;
    }

    public final boolean hasExcludedPages() {
        return this.excludedPages != null && !(this.excludedPages instanceof SdkAutoConstructList);
    }

    public final List<String> excludedPages() {
        return this.excludedPages;
    }

    public final boolean hasIncludedPages() {
        return this.includedPages != null && !(this.includedPages instanceof SdkAutoConstructList);
    }

    public final List<String> includedPages() {
        return this.includedPages;
    }

    public final boolean hasFavoritePages() {
        return this.favoritePages != null && !(this.favoritePages instanceof SdkAutoConstructList);
    }

    public final List<String> favoritePages() {
        return this.favoritePages;
    }

    public final Double sessionSampleRate() {
        return this.sessionSampleRate;
    }

    public final String guestRoleArn() {
        return this.guestRoleArn;
    }

    public final Boolean allowCookies() {
        return this.allowCookies;
    }

    public final List<Telemetry> telemetries() {
        return TelemetriesCopier.copyStringToEnum(this.telemetries);
    }

    public final boolean hasTelemetries() {
        return this.telemetries != null && !(this.telemetries instanceof SdkAutoConstructList);
    }

    public final List<String> telemetriesAsStrings() {
        return this.telemetries;
    }

    public final Boolean enableXRay() {
        return this.enableXRay;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedPages() ? this.excludedPages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludedPages() ? this.includedPages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFavoritePages() ? this.favoritePages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionSampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.guestRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowCookies());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTelemetries() ? this.telemetriesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableXRay());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppMonitorConfiguration)) {
            return false;
        }
        AppMonitorConfiguration other = (AppMonitorConfiguration)obj;
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && this.hasExcludedPages() == other.hasExcludedPages() && Objects.equals(this.excludedPages(), other.excludedPages()) && this.hasIncludedPages() == other.hasIncludedPages() && Objects.equals(this.includedPages(), other.includedPages()) && this.hasFavoritePages() == other.hasFavoritePages() && Objects.equals(this.favoritePages(), other.favoritePages()) && Objects.equals(this.sessionSampleRate(), other.sessionSampleRate()) && Objects.equals(this.guestRoleArn(), other.guestRoleArn()) && Objects.equals(this.allowCookies(), other.allowCookies()) && this.hasTelemetries() == other.hasTelemetries() && Objects.equals(this.telemetriesAsStrings(), other.telemetriesAsStrings()) && Objects.equals(this.enableXRay(), other.enableXRay());
    }

    public final String toString() {
        return ToString.builder((String)"AppMonitorConfiguration").add("IdentityPoolId", (Object)this.identityPoolId()).add("ExcludedPages", this.hasExcludedPages() ? this.excludedPages() : null).add("IncludedPages", this.hasIncludedPages() ? this.includedPages() : null).add("FavoritePages", this.hasFavoritePages() ? this.favoritePages() : null).add("SessionSampleRate", (Object)this.sessionSampleRate()).add("GuestRoleArn", (Object)this.guestRoleArn()).add("AllowCookies", (Object)this.allowCookies()).add("Telemetries", this.hasTelemetries() ? this.telemetriesAsStrings() : null).add("EnableXRay", (Object)this.enableXRay()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "ExcludedPages": {
                return Optional.ofNullable(clazz.cast(this.excludedPages()));
            }
            case "IncludedPages": {
                return Optional.ofNullable(clazz.cast(this.includedPages()));
            }
            case "FavoritePages": {
                return Optional.ofNullable(clazz.cast(this.favoritePages()));
            }
            case "SessionSampleRate": {
                return Optional.ofNullable(clazz.cast(this.sessionSampleRate()));
            }
            case "GuestRoleArn": {
                return Optional.ofNullable(clazz.cast(this.guestRoleArn()));
            }
            case "AllowCookies": {
                return Optional.ofNullable(clazz.cast(this.allowCookies()));
            }
            case "Telemetries": {
                return Optional.ofNullable(clazz.cast(this.telemetriesAsStrings()));
            }
            case "EnableXRay": {
                return Optional.ofNullable(clazz.cast(this.enableXRay()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IdentityPoolId", IDENTITY_POOL_ID_FIELD);
        map.put("ExcludedPages", EXCLUDED_PAGES_FIELD);
        map.put("IncludedPages", INCLUDED_PAGES_FIELD);
        map.put("FavoritePages", FAVORITE_PAGES_FIELD);
        map.put("SessionSampleRate", SESSION_SAMPLE_RATE_FIELD);
        map.put("GuestRoleArn", GUEST_ROLE_ARN_FIELD);
        map.put("AllowCookies", ALLOW_COOKIES_FIELD);
        map.put("Telemetries", TELEMETRIES_FIELD);
        map.put("EnableXRay", ENABLE_X_RAY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppMonitorConfiguration, T> g) {
        return obj -> g.apply((AppMonitorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private List<String> excludedPages = DefaultSdkAutoConstructList.getInstance();
        private List<String> includedPages = DefaultSdkAutoConstructList.getInstance();
        private List<String> favoritePages = DefaultSdkAutoConstructList.getInstance();
        private Double sessionSampleRate;
        private String guestRoleArn;
        private Boolean allowCookies;
        private List<String> telemetries = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableXRay;

        private BuilderImpl() {
        }

        private BuilderImpl(AppMonitorConfiguration model) {
            this.identityPoolId(model.identityPoolId);
            this.excludedPages(model.excludedPages);
            this.includedPages(model.includedPages);
            this.favoritePages(model.favoritePages);
            this.sessionSampleRate(model.sessionSampleRate);
            this.guestRoleArn(model.guestRoleArn);
            this.allowCookies(model.allowCookies);
            this.telemetriesWithStrings(model.telemetries);
            this.enableXRay(model.enableXRay);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final Collection<String> getExcludedPages() {
            if (this.excludedPages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedPages;
        }

        public final void setExcludedPages(Collection<String> excludedPages) {
            this.excludedPages = PagesCopier.copy(excludedPages);
        }

        @Override
        public final Builder excludedPages(Collection<String> excludedPages) {
            this.excludedPages = PagesCopier.copy(excludedPages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedPages(String ... excludedPages) {
            this.excludedPages(Arrays.asList(excludedPages));
            return this;
        }

        public final Collection<String> getIncludedPages() {
            if (this.includedPages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includedPages;
        }

        public final void setIncludedPages(Collection<String> includedPages) {
            this.includedPages = PagesCopier.copy(includedPages);
        }

        @Override
        public final Builder includedPages(Collection<String> includedPages) {
            this.includedPages = PagesCopier.copy(includedPages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedPages(String ... includedPages) {
            this.includedPages(Arrays.asList(includedPages));
            return this;
        }

        public final Collection<String> getFavoritePages() {
            if (this.favoritePages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.favoritePages;
        }

        public final void setFavoritePages(Collection<String> favoritePages) {
            this.favoritePages = FavoritePagesCopier.copy(favoritePages);
        }

        @Override
        public final Builder favoritePages(Collection<String> favoritePages) {
            this.favoritePages = FavoritePagesCopier.copy(favoritePages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder favoritePages(String ... favoritePages) {
            this.favoritePages(Arrays.asList(favoritePages));
            return this;
        }

        public final Double getSessionSampleRate() {
            return this.sessionSampleRate;
        }

        public final void setSessionSampleRate(Double sessionSampleRate) {
            this.sessionSampleRate = sessionSampleRate;
        }

        @Override
        public final Builder sessionSampleRate(Double sessionSampleRate) {
            this.sessionSampleRate = sessionSampleRate;
            return this;
        }

        public final String getGuestRoleArn() {
            return this.guestRoleArn;
        }

        public final void setGuestRoleArn(String guestRoleArn) {
            this.guestRoleArn = guestRoleArn;
        }

        @Override
        public final Builder guestRoleArn(String guestRoleArn) {
            this.guestRoleArn = guestRoleArn;
            return this;
        }

        public final Boolean getAllowCookies() {
            return this.allowCookies;
        }

        public final void setAllowCookies(Boolean allowCookies) {
            this.allowCookies = allowCookies;
        }

        @Override
        public final Builder allowCookies(Boolean allowCookies) {
            this.allowCookies = allowCookies;
            return this;
        }

        public final Collection<String> getTelemetries() {
            if (this.telemetries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.telemetries;
        }

        public final void setTelemetries(Collection<String> telemetries) {
            this.telemetries = TelemetriesCopier.copy(telemetries);
        }

        @Override
        public final Builder telemetriesWithStrings(Collection<String> telemetries) {
            this.telemetries = TelemetriesCopier.copy(telemetries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetriesWithStrings(String ... telemetries) {
            this.telemetriesWithStrings(Arrays.asList(telemetries));
            return this;
        }

        @Override
        public final Builder telemetries(Collection<Telemetry> telemetries) {
            this.telemetries = TelemetriesCopier.copyEnumToString(telemetries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetries(Telemetry ... telemetries) {
            this.telemetries(Arrays.asList(telemetries));
            return this;
        }

        public final Boolean getEnableXRay() {
            return this.enableXRay;
        }

        public final void setEnableXRay(Boolean enableXRay) {
            this.enableXRay = enableXRay;
        }

        @Override
        public final Builder enableXRay(Boolean enableXRay) {
            this.enableXRay = enableXRay;
            return this;
        }

        public AppMonitorConfiguration build() {
            return new AppMonitorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppMonitorConfiguration> {
        public Builder identityPoolId(String var1);

        public Builder excludedPages(Collection<String> var1);

        public Builder excludedPages(String ... var1);

        public Builder includedPages(Collection<String> var1);

        public Builder includedPages(String ... var1);

        public Builder favoritePages(Collection<String> var1);

        public Builder favoritePages(String ... var1);

        public Builder sessionSampleRate(Double var1);

        public Builder guestRoleArn(String var1);

        public Builder allowCookies(Boolean var1);

        public Builder telemetriesWithStrings(Collection<String> var1);

        public Builder telemetriesWithStrings(String ... var1);

        public Builder telemetries(Collection<Telemetry> var1);

        public Builder telemetries(Telemetry ... var1);

        public Builder enableXRay(Boolean var1);
    }
}

