/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsError;
import software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsErrorsCopier;
import software.amazon.awssdk.services.rum.model.MetricDefinitionIdsCopier;
import software.amazon.awssdk.services.rum.model.RumResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteRumMetricDefinitionsResponse
extends RumResponse
implements ToCopyableBuilder<Builder, BatchDeleteRumMetricDefinitionsResponse> {
    private static final SdkField<List<BatchDeleteRumMetricDefinitionsError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchDeleteRumMetricDefinitionsResponse.getter(BatchDeleteRumMetricDefinitionsResponse::errors)).setter(BatchDeleteRumMetricDefinitionsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDeleteRumMetricDefinitionsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> METRIC_DEFINITION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricDefinitionIds").getter(BatchDeleteRumMetricDefinitionsResponse.getter(BatchDeleteRumMetricDefinitionsResponse::metricDefinitionIds)).setter(BatchDeleteRumMetricDefinitionsResponse.setter(Builder::metricDefinitionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDefinitionIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, METRIC_DEFINITION_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteRumMetricDefinitionsResponse.memberNameToFieldInitializer();
    private final List<BatchDeleteRumMetricDefinitionsError> errors;
    private final List<String> metricDefinitionIds;

    private BatchDeleteRumMetricDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.metricDefinitionIds = builder.metricDefinitionIds;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchDeleteRumMetricDefinitionsError> errors() {
        return this.errors;
    }

    public final boolean hasMetricDefinitionIds() {
        return this.metricDefinitionIds != null && !(this.metricDefinitionIds instanceof SdkAutoConstructList);
    }

    public final List<String> metricDefinitionIds() {
        return this.metricDefinitionIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDefinitionIds() ? this.metricDefinitionIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteRumMetricDefinitionsResponse)) {
            return false;
        }
        BatchDeleteRumMetricDefinitionsResponse other = (BatchDeleteRumMetricDefinitionsResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasMetricDefinitionIds() == other.hasMetricDefinitionIds() && Objects.equals(this.metricDefinitionIds(), other.metricDefinitionIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteRumMetricDefinitionsResponse").add("Errors", this.hasErrors() ? this.errors() : null).add("MetricDefinitionIds", this.hasMetricDefinitionIds() ? this.metricDefinitionIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "MetricDefinitionIds": {
                return Optional.ofNullable(clazz.cast(this.metricDefinitionIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Errors", ERRORS_FIELD);
        map.put("MetricDefinitionIds", METRIC_DEFINITION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteRumMetricDefinitionsResponse, T> g) {
        return obj -> g.apply((BatchDeleteRumMetricDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RumResponse.BuilderImpl
    implements Builder {
        private List<BatchDeleteRumMetricDefinitionsError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<String> metricDefinitionIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteRumMetricDefinitionsResponse model) {
            super(model);
            this.errors(model.errors);
            this.metricDefinitionIds(model.metricDefinitionIds);
        }

        public final List<BatchDeleteRumMetricDefinitionsError.Builder> getErrors() {
            List<BatchDeleteRumMetricDefinitionsError.Builder> result = BatchDeleteRumMetricDefinitionsErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchDeleteRumMetricDefinitionsError.BuilderImpl> errors) {
            this.errors = BatchDeleteRumMetricDefinitionsErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchDeleteRumMetricDefinitionsError> errors) {
            this.errors = BatchDeleteRumMetricDefinitionsErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchDeleteRumMetricDefinitionsError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchDeleteRumMetricDefinitionsError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchDeleteRumMetricDefinitionsError)((BatchDeleteRumMetricDefinitionsError.Builder)BatchDeleteRumMetricDefinitionsError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getMetricDefinitionIds() {
            if (this.metricDefinitionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricDefinitionIds;
        }

        public final void setMetricDefinitionIds(Collection<String> metricDefinitionIds) {
            this.metricDefinitionIds = MetricDefinitionIdsCopier.copy(metricDefinitionIds);
        }

        @Override
        public final Builder metricDefinitionIds(Collection<String> metricDefinitionIds) {
            this.metricDefinitionIds = MetricDefinitionIdsCopier.copy(metricDefinitionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitionIds(String ... metricDefinitionIds) {
            this.metricDefinitionIds(Arrays.asList(metricDefinitionIds));
            return this;
        }

        @Override
        public BatchDeleteRumMetricDefinitionsResponse build() {
            return new BatchDeleteRumMetricDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RumResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteRumMetricDefinitionsResponse> {
        public Builder errors(Collection<BatchDeleteRumMetricDefinitionsError> var1);

        public Builder errors(BatchDeleteRumMetricDefinitionsError ... var1);

        public Builder errors(Consumer<BatchDeleteRumMetricDefinitionsError.Builder> ... var1);

        public Builder metricDefinitionIds(Collection<String> var1);

        public Builder metricDefinitionIds(String ... var1);
    }
}

