/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsError;
import software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsErrorsCopier;
import software.amazon.awssdk.services.rum.model.MetricDefinition;
import software.amazon.awssdk.services.rum.model.MetricDefinitionsCopier;
import software.amazon.awssdk.services.rum.model.RumResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateRumMetricDefinitionsResponse
extends RumResponse
implements ToCopyableBuilder<Builder, BatchCreateRumMetricDefinitionsResponse> {
    private static final SdkField<List<BatchCreateRumMetricDefinitionsError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchCreateRumMetricDefinitionsResponse.getter(BatchCreateRumMetricDefinitionsResponse::errors)).setter(BatchCreateRumMetricDefinitionsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchCreateRumMetricDefinitionsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MetricDefinition>> METRIC_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricDefinitions").getter(BatchCreateRumMetricDefinitionsResponse.getter(BatchCreateRumMetricDefinitionsResponse::metricDefinitions)).setter(BatchCreateRumMetricDefinitionsResponse.setter(Builder::metricDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, METRIC_DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchCreateRumMetricDefinitionsResponse.memberNameToFieldInitializer();
    private final List<BatchCreateRumMetricDefinitionsError> errors;
    private final List<MetricDefinition> metricDefinitions;

    private BatchCreateRumMetricDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.metricDefinitions = builder.metricDefinitions;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchCreateRumMetricDefinitionsError> errors() {
        return this.errors;
    }

    public final boolean hasMetricDefinitions() {
        return this.metricDefinitions != null && !(this.metricDefinitions instanceof SdkAutoConstructList);
    }

    public final List<MetricDefinition> metricDefinitions() {
        return this.metricDefinitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDefinitions() ? this.metricDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateRumMetricDefinitionsResponse)) {
            return false;
        }
        BatchCreateRumMetricDefinitionsResponse other = (BatchCreateRumMetricDefinitionsResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasMetricDefinitions() == other.hasMetricDefinitions() && Objects.equals(this.metricDefinitions(), other.metricDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateRumMetricDefinitionsResponse").add("Errors", this.hasErrors() ? this.errors() : null).add("MetricDefinitions", this.hasMetricDefinitions() ? this.metricDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "MetricDefinitions": {
                return Optional.ofNullable(clazz.cast(this.metricDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Errors", ERRORS_FIELD);
        map.put("MetricDefinitions", METRIC_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateRumMetricDefinitionsResponse, T> g) {
        return obj -> g.apply((BatchCreateRumMetricDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RumResponse.BuilderImpl
    implements Builder {
        private List<BatchCreateRumMetricDefinitionsError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<MetricDefinition> metricDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateRumMetricDefinitionsResponse model) {
            super(model);
            this.errors(model.errors);
            this.metricDefinitions(model.metricDefinitions);
        }

        public final List<BatchCreateRumMetricDefinitionsError.Builder> getErrors() {
            List<BatchCreateRumMetricDefinitionsError.Builder> result = BatchCreateRumMetricDefinitionsErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchCreateRumMetricDefinitionsError.BuilderImpl> errors) {
            this.errors = BatchCreateRumMetricDefinitionsErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchCreateRumMetricDefinitionsError> errors) {
            this.errors = BatchCreateRumMetricDefinitionsErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchCreateRumMetricDefinitionsError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchCreateRumMetricDefinitionsError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchCreateRumMetricDefinitionsError)((BatchCreateRumMetricDefinitionsError.Builder)BatchCreateRumMetricDefinitionsError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MetricDefinition.Builder> getMetricDefinitions() {
            List<MetricDefinition.Builder> result = MetricDefinitionsCopier.copyToBuilder(this.metricDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDefinitions(Collection<MetricDefinition.BuilderImpl> metricDefinitions) {
            this.metricDefinitions = MetricDefinitionsCopier.copyFromBuilder(metricDefinitions);
        }

        @Override
        public final Builder metricDefinitions(Collection<MetricDefinition> metricDefinitions) {
            this.metricDefinitions = MetricDefinitionsCopier.copy(metricDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitions(MetricDefinition ... metricDefinitions) {
            this.metricDefinitions(Arrays.asList(metricDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitions(Consumer<MetricDefinition.Builder> ... metricDefinitions) {
            this.metricDefinitions(Stream.of(metricDefinitions).map(c -> (MetricDefinition)((MetricDefinition.Builder)MetricDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchCreateRumMetricDefinitionsResponse build() {
            return new BatchCreateRumMetricDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RumResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateRumMetricDefinitionsResponse> {
        public Builder errors(Collection<BatchCreateRumMetricDefinitionsError> var1);

        public Builder errors(BatchCreateRumMetricDefinitionsError ... var1);

        public Builder errors(Consumer<BatchCreateRumMetricDefinitionsError.Builder> ... var1);

        public Builder metricDefinitions(Collection<MetricDefinition> var1);

        public Builder metricDefinitions(MetricDefinition ... var1);

        public Builder metricDefinitions(Consumer<MetricDefinition.Builder> ... var1);
    }
}

