/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rum.model.StateEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppMonitorSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppMonitorSummary> {
    private static final SdkField<String> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Created").getter(AppMonitorSummary.getter(AppMonitorSummary::created)).setter(AppMonitorSummary.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AppMonitorSummary.getter(AppMonitorSummary::id)).setter(AppMonitorSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModified").getter(AppMonitorSummary.getter(AppMonitorSummary::lastModified)).setter(AppMonitorSummary.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AppMonitorSummary.getter(AppMonitorSummary::name)).setter(AppMonitorSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(AppMonitorSummary.getter(AppMonitorSummary::stateAsString)).setter(AppMonitorSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_FIELD, ID_FIELD, LAST_MODIFIED_FIELD, NAME_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String created;
    private final String id;
    private final String lastModified;
    private final String name;
    private final String state;

    private AppMonitorSummary(BuilderImpl builder) {
        this.created = builder.created;
        this.id = builder.id;
        this.lastModified = builder.lastModified;
        this.name = builder.name;
        this.state = builder.state;
    }

    public final String created() {
        return this.created;
    }

    public final String id() {
        return this.id;
    }

    public final String lastModified() {
        return this.lastModified;
    }

    public final String name() {
        return this.name;
    }

    public final StateEnum state() {
        return StateEnum.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppMonitorSummary)) {
            return false;
        }
        AppMonitorSummary other = (AppMonitorSummary)obj;
        return Objects.equals(this.created(), other.created()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AppMonitorSummary").add("Created", (Object)this.created()).add("Id", (Object)this.id()).add("LastModified", (Object)this.lastModified()).add("Name", (Object)this.name()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppMonitorSummary, T> g) {
        return obj -> g.apply((AppMonitorSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String created;
        private String id;
        private String lastModified;
        private String name;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(AppMonitorSummary model) {
            this.created(model.created);
            this.id(model.id);
            this.lastModified(model.lastModified);
            this.name(model.name);
            this.state(model.state);
        }

        public final String getCreated() {
            return this.created;
        }

        public final void setCreated(String created) {
            this.created = created;
        }

        @Override
        public final Builder created(String created) {
            this.created = created;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StateEnum state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public AppMonitorSummary build() {
            return new AppMonitorSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppMonitorSummary> {
        public Builder created(String var1);

        public Builder id(String var1);

        public Builder lastModified(String var1);

        public Builder name(String var1);

        public Builder state(String var1);

        public Builder state(StateEnum var1);
    }
}

