/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rtbfabric.model.Action;
import software.amazon.awssdk.services.rtbfabric.model.Filter;
import software.amazon.awssdk.services.rtbfabric.model.FilterConfigurationCopier;
import software.amazon.awssdk.services.rtbfabric.model.FilterType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenRtbAttributeModuleParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenRtbAttributeModuleParameters> {
    private static final SdkField<String> FILTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterType").getter(OpenRtbAttributeModuleParameters.getter(OpenRtbAttributeModuleParameters::filterTypeAsString)).setter(OpenRtbAttributeModuleParameters.setter(Builder::filterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterType").build()}).build();
    private static final SdkField<List<Filter>> FILTER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filterConfiguration").getter(OpenRtbAttributeModuleParameters.getter(OpenRtbAttributeModuleParameters::filterConfiguration)).setter(OpenRtbAttributeModuleParameters.setter(Builder::filterConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Action> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("action").getter(OpenRtbAttributeModuleParameters.getter(OpenRtbAttributeModuleParameters::action)).setter(OpenRtbAttributeModuleParameters.setter(Builder::action)).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<Float> HOLDBACK_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("holdbackPercentage").getter(OpenRtbAttributeModuleParameters.getter(OpenRtbAttributeModuleParameters::holdbackPercentage)).setter(OpenRtbAttributeModuleParameters.setter(Builder::holdbackPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("holdbackPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_TYPE_FIELD, FILTER_CONFIGURATION_FIELD, ACTION_FIELD, HOLDBACK_PERCENTAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OpenRtbAttributeModuleParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String filterType;
    private final List<Filter> filterConfiguration;
    private final Action action;
    private final Float holdbackPercentage;

    private OpenRtbAttributeModuleParameters(BuilderImpl builder) {
        this.filterType = builder.filterType;
        this.filterConfiguration = builder.filterConfiguration;
        this.action = builder.action;
        this.holdbackPercentage = builder.holdbackPercentage;
    }

    public final FilterType filterType() {
        return FilterType.fromValue(this.filterType);
    }

    public final String filterTypeAsString() {
        return this.filterType;
    }

    public final boolean hasFilterConfiguration() {
        return this.filterConfiguration != null && !(this.filterConfiguration instanceof SdkAutoConstructList);
    }

    public final List<Filter> filterConfiguration() {
        return this.filterConfiguration;
    }

    public final Action action() {
        return this.action;
    }

    public final Float holdbackPercentage() {
        return this.holdbackPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterConfiguration() ? this.filterConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.holdbackPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenRtbAttributeModuleParameters)) {
            return false;
        }
        OpenRtbAttributeModuleParameters other = (OpenRtbAttributeModuleParameters)obj;
        return Objects.equals(this.filterTypeAsString(), other.filterTypeAsString()) && this.hasFilterConfiguration() == other.hasFilterConfiguration() && Objects.equals(this.filterConfiguration(), other.filterConfiguration()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.holdbackPercentage(), other.holdbackPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"OpenRtbAttributeModuleParameters").add("FilterType", (Object)this.filterTypeAsString()).add("FilterConfiguration", this.hasFilterConfiguration() ? this.filterConfiguration() : null).add("Action", (Object)this.action()).add("HoldbackPercentage", (Object)this.holdbackPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterType": {
                return Optional.ofNullable(clazz.cast(this.filterTypeAsString()));
            }
            case "filterConfiguration": {
                return Optional.ofNullable(clazz.cast(this.filterConfiguration()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "holdbackPercentage": {
                return Optional.ofNullable(clazz.cast(this.holdbackPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filterType", FILTER_TYPE_FIELD);
        map.put("filterConfiguration", FILTER_CONFIGURATION_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("holdbackPercentage", HOLDBACK_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenRtbAttributeModuleParameters, T> g) {
        return obj -> g.apply((OpenRtbAttributeModuleParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterType;
        private List<Filter> filterConfiguration = DefaultSdkAutoConstructList.getInstance();
        private Action action;
        private Float holdbackPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenRtbAttributeModuleParameters model) {
            this.filterType(model.filterType);
            this.filterConfiguration(model.filterConfiguration);
            this.action(model.action);
            this.holdbackPercentage(model.holdbackPercentage);
        }

        public final String getFilterType() {
            return this.filterType;
        }

        public final void setFilterType(String filterType) {
            this.filterType = filterType;
        }

        @Override
        public final Builder filterType(String filterType) {
            this.filterType = filterType;
            return this;
        }

        @Override
        public final Builder filterType(FilterType filterType) {
            this.filterType(filterType == null ? null : filterType.toString());
            return this;
        }

        public final List<Filter.Builder> getFilterConfiguration() {
            List<Filter.Builder> result = FilterConfigurationCopier.copyToBuilder(this.filterConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterConfiguration(Collection<Filter.BuilderImpl> filterConfiguration) {
            this.filterConfiguration = FilterConfigurationCopier.copyFromBuilder(filterConfiguration);
        }

        @Override
        public final Builder filterConfiguration(Collection<Filter> filterConfiguration) {
            this.filterConfiguration = FilterConfigurationCopier.copy(filterConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterConfiguration(Filter ... filterConfiguration) {
            this.filterConfiguration(Arrays.asList(filterConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterConfiguration(Consumer<Filter.Builder> ... filterConfiguration) {
            this.filterConfiguration(Stream.of(filterConfiguration).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Action.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final Float getHoldbackPercentage() {
            return this.holdbackPercentage;
        }

        public final void setHoldbackPercentage(Float holdbackPercentage) {
            this.holdbackPercentage = holdbackPercentage;
        }

        @Override
        public final Builder holdbackPercentage(Float holdbackPercentage) {
            this.holdbackPercentage = holdbackPercentage;
            return this;
        }

        public OpenRtbAttributeModuleParameters build() {
            return new OpenRtbAttributeModuleParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenRtbAttributeModuleParameters> {
        public Builder filterType(String var1);

        public Builder filterType(FilterType var1);

        public Builder filterConfiguration(Collection<Filter> var1);

        public Builder filterConfiguration(Filter ... var1);

        public Builder filterConfiguration(Consumer<Filter.Builder> ... var1);

        public Builder action(Action var1);

        default public Builder action(Consumer<Action.Builder> action) {
            return this.action((Action)((Action.Builder)Action.builder().applyMutation(action)).build());
        }

        public Builder holdbackPercentage(Float var1);
    }
}

