/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLinkModuleFlowRequest extends RtbFabricRequest implements
        ToCopyableBuilder<UpdateLinkModuleFlowRequest.Builder, UpdateLinkModuleFlowRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateLinkModuleFlowRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayId").getter(getter(UpdateLinkModuleFlowRequest::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayId").build()).build();

    private static final SdkField<String> LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("linkId")
            .getter(getter(UpdateLinkModuleFlowRequest::linkId)).setter(setter(Builder::linkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("linkId").build()).build();

    private static final SdkField<List<ModuleConfiguration>> MODULES_FIELD = SdkField
            .<List<ModuleConfiguration>> builder(MarshallingType.LIST)
            .memberName("modules")
            .getter(getter(UpdateLinkModuleFlowRequest::modules))
            .setter(setter(Builder::modules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModuleConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModuleConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            GATEWAY_ID_FIELD, LINK_ID_FIELD, MODULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String gatewayId;

    private final String linkId;

    private final List<ModuleConfiguration> modules;

    private UpdateLinkModuleFlowRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.gatewayId = builder.gatewayId;
        this.linkId = builder.linkId;
        this.modules = builder.modules;
    }

    /**
     * <p>
     * The unique client token.
     * </p>
     * 
     * @return The unique client token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique identifier of the gateway.
     * </p>
     * 
     * @return The unique identifier of the gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The unique identifier of the link.
     * </p>
     * 
     * @return The unique identifier of the link.
     */
    public final String linkId() {
        return linkId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Modules property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasModules() {
        return modules != null && !(modules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration of a module.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModules} method.
     * </p>
     * 
     * @return The configuration of a module.
     */
    public final List<ModuleConfiguration> modules() {
        return modules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(linkId());
        hashCode = 31 * hashCode + Objects.hashCode(hasModules() ? modules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLinkModuleFlowRequest)) {
            return false;
        }
        UpdateLinkModuleFlowRequest other = (UpdateLinkModuleFlowRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(gatewayId(), other.gatewayId())
                && Objects.equals(linkId(), other.linkId()) && hasModules() == other.hasModules()
                && Objects.equals(modules(), other.modules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLinkModuleFlowRequest").add("ClientToken", clientToken()).add("GatewayId", gatewayId())
                .add("LinkId", linkId()).add("Modules", hasModules() ? modules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "linkId":
            return Optional.ofNullable(clazz.cast(linkId()));
        case "modules":
            return Optional.ofNullable(clazz.cast(modules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("linkId", LINK_ID_FIELD);
        map.put("modules", MODULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLinkModuleFlowRequest, T> g) {
        return obj -> g.apply((UpdateLinkModuleFlowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RtbFabricRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLinkModuleFlowRequest> {
        /**
         * <p>
         * The unique client token.
         * </p>
         * 
         * @param clientToken
         *        The unique client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique identifier of the gateway.
         * </p>
         * 
         * @param gatewayId
         *        The unique identifier of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The unique identifier of the link.
         * </p>
         * 
         * @param linkId
         *        The unique identifier of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkId(String linkId);

        /**
         * <p>
         * The configuration of a module.
         * </p>
         * 
         * @param modules
         *        The configuration of a module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modules(Collection<ModuleConfiguration> modules);

        /**
         * <p>
         * The configuration of a module.
         * </p>
         * 
         * @param modules
         *        The configuration of a module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modules(ModuleConfiguration... modules);

        /**
         * <p>
         * The configuration of a module.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rtbfabric.model.ModuleConfiguration.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.rtbfabric.model.ModuleConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rtbfabric.model.ModuleConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #modules(List<ModuleConfiguration>)}.
         * 
         * @param modules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rtbfabric.model.ModuleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modules(java.util.Collection<ModuleConfiguration>)
         */
        Builder modules(Consumer<ModuleConfiguration.Builder>... modules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RtbFabricRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String gatewayId;

        private String linkId;

        private List<ModuleConfiguration> modules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLinkModuleFlowRequest model) {
            super(model);
            clientToken(model.clientToken);
            gatewayId(model.gatewayId);
            linkId(model.linkId);
            modules(model.modules);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getLinkId() {
            return linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final List<ModuleConfiguration.Builder> getModules() {
            List<ModuleConfiguration.Builder> result = ModuleConfigurationListCopier.copyToBuilder(this.modules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModules(Collection<ModuleConfiguration.BuilderImpl> modules) {
            this.modules = ModuleConfigurationListCopier.copyFromBuilder(modules);
        }

        @Override
        public final Builder modules(Collection<ModuleConfiguration> modules) {
            this.modules = ModuleConfigurationListCopier.copy(modules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modules(ModuleConfiguration... modules) {
            modules(Arrays.asList(modules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modules(Consumer<ModuleConfiguration.Builder>... modules) {
            modules(Stream.of(modules).map(c -> ModuleConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLinkModuleFlowRequest build() {
            return new UpdateLinkModuleFlowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
