/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a module.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModuleConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ModuleConfiguration.Builder, ModuleConfiguration> {
    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(ModuleConfiguration::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ModuleConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> DEPENDS_ON_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dependsOn")
            .getter(getter(ModuleConfiguration::dependsOn))
            .setter(setter(Builder::dependsOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependsOn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ModuleParameters> MODULE_PARAMETERS_FIELD = SdkField
            .<ModuleParameters> builder(MarshallingType.SDK_POJO).memberName("moduleParameters")
            .getter(getter(ModuleConfiguration::moduleParameters)).setter(setter(Builder::moduleParameters))
            .constructor(ModuleParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moduleParameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, NAME_FIELD,
            DEPENDS_ON_FIELD, MODULE_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String version;

    private final String name;

    private final List<String> dependsOn;

    private final ModuleParameters moduleParameters;

    private ModuleConfiguration(BuilderImpl builder) {
        this.version = builder.version;
        this.name = builder.name;
        this.dependsOn = builder.dependsOn;
        this.moduleParameters = builder.moduleParameters;
    }

    /**
     * <p>
     * The version of the module.
     * </p>
     * 
     * @return The version of the module.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The name of the module.
     * </p>
     * 
     * @return The name of the module.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the DependsOn property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDependsOn() {
        return dependsOn != null && !(dependsOn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dependencies of the module.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependsOn} method.
     * </p>
     * 
     * @return The dependencies of the module.
     */
    public final List<String> dependsOn() {
        return dependsOn;
    }

    /**
     * <p>
     * Describes the parameters of a module.
     * </p>
     * 
     * @return Describes the parameters of a module.
     */
    public final ModuleParameters moduleParameters() {
        return moduleParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependsOn() ? dependsOn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(moduleParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModuleConfiguration)) {
            return false;
        }
        ModuleConfiguration other = (ModuleConfiguration) obj;
        return Objects.equals(version(), other.version()) && Objects.equals(name(), other.name())
                && hasDependsOn() == other.hasDependsOn() && Objects.equals(dependsOn(), other.dependsOn())
                && Objects.equals(moduleParameters(), other.moduleParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModuleConfiguration").add("Version", version()).add("Name", name())
                .add("DependsOn", hasDependsOn() ? dependsOn() : null).add("ModuleParameters", moduleParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "dependsOn":
            return Optional.ofNullable(clazz.cast(dependsOn()));
        case "moduleParameters":
            return Optional.ofNullable(clazz.cast(moduleParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("version", VERSION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("dependsOn", DEPENDS_ON_FIELD);
        map.put("moduleParameters", MODULE_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModuleConfiguration, T> g) {
        return obj -> g.apply((ModuleConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModuleConfiguration> {
        /**
         * <p>
         * The version of the module.
         * </p>
         * 
         * @param version
         *        The version of the module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The name of the module.
         * </p>
         * 
         * @param name
         *        The name of the module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The dependencies of the module.
         * </p>
         * 
         * @param dependsOn
         *        The dependencies of the module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(Collection<String> dependsOn);

        /**
         * <p>
         * The dependencies of the module.
         * </p>
         * 
         * @param dependsOn
         *        The dependencies of the module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(String... dependsOn);

        /**
         * <p>
         * Describes the parameters of a module.
         * </p>
         * 
         * @param moduleParameters
         *        Describes the parameters of a module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moduleParameters(ModuleParameters moduleParameters);

        /**
         * <p>
         * Describes the parameters of a module.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModuleParameters.Builder} avoiding the
         * need to create one manually via {@link ModuleParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModuleParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #moduleParameters(ModuleParameters)}.
         * 
         * @param moduleParameters
         *        a consumer that will call methods on {@link ModuleParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #moduleParameters(ModuleParameters)
         */
        default Builder moduleParameters(Consumer<ModuleParameters.Builder> moduleParameters) {
            return moduleParameters(ModuleParameters.builder().applyMutation(moduleParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String version;

        private String name;

        private List<String> dependsOn = DefaultSdkAutoConstructList.getInstance();

        private ModuleParameters moduleParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ModuleConfiguration model) {
            version(model.version);
            name(model.name);
            dependsOn(model.dependsOn);
            moduleParameters(model.moduleParameters);
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getDependsOn() {
            if (dependsOn instanceof SdkAutoConstructList) {
                return null;
            }
            return dependsOn;
        }

        public final void setDependsOn(Collection<String> dependsOn) {
            this.dependsOn = FlowModuleNameListCopier.copy(dependsOn);
        }

        @Override
        public final Builder dependsOn(Collection<String> dependsOn) {
            this.dependsOn = FlowModuleNameListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(String... dependsOn) {
            dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        public final ModuleParameters.Builder getModuleParameters() {
            return moduleParameters != null ? moduleParameters.toBuilder() : null;
        }

        public final void setModuleParameters(ModuleParameters.BuilderImpl moduleParameters) {
            this.moduleParameters = moduleParameters != null ? moduleParameters.build() : null;
        }

        @Override
        public final Builder moduleParameters(ModuleParameters moduleParameters) {
            this.moduleParameters = moduleParameters;
            return this;
        }

        @Override
        public ModuleConfiguration build() {
            return new ModuleConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
