/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a managed endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedEndpointConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedEndpointConfiguration.Builder, ManagedEndpointConfiguration> {
    private static final SdkField<AutoScalingGroupsConfiguration> AUTO_SCALING_GROUPS_FIELD = SdkField
            .<AutoScalingGroupsConfiguration> builder(MarshallingType.SDK_POJO).memberName("autoScalingGroups")
            .getter(getter(ManagedEndpointConfiguration::autoScalingGroups)).setter(setter(Builder::autoScalingGroups))
            .constructor(AutoScalingGroupsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroups").build()).build();

    private static final SdkField<EksEndpointsConfiguration> EKS_ENDPOINTS_FIELD = SdkField
            .<EksEndpointsConfiguration> builder(MarshallingType.SDK_POJO).memberName("eksEndpoints")
            .getter(getter(ManagedEndpointConfiguration::eksEndpoints)).setter(setter(Builder::eksEndpoints))
            .constructor(EksEndpointsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksEndpoints").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUPS_FIELD,
            EKS_ENDPOINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutoScalingGroupsConfiguration autoScalingGroups;

    private final EksEndpointsConfiguration eksEndpoints;

    private final Type type;

    private ManagedEndpointConfiguration(BuilderImpl builder) {
        this.autoScalingGroups = builder.autoScalingGroups;
        this.eksEndpoints = builder.eksEndpoints;
        this.type = builder.type;
    }

    /**
     * <p>
     * Describes the configuration of an auto scaling group.
     * </p>
     * 
     * @return Describes the configuration of an auto scaling group.
     */
    public final AutoScalingGroupsConfiguration autoScalingGroups() {
        return autoScalingGroups;
    }

    /**
     * <p>
     * Describes the configuration of an Amazon Elastic Kubernetes Service endpoint.
     * </p>
     * 
     * @return Describes the configuration of an Amazon Elastic Kubernetes Service endpoint.
     */
    public final EksEndpointsConfiguration eksEndpoints() {
        return eksEndpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(eksEndpoints());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedEndpointConfiguration)) {
            return false;
        }
        ManagedEndpointConfiguration other = (ManagedEndpointConfiguration) obj;
        return Objects.equals(autoScalingGroups(), other.autoScalingGroups())
                && Objects.equals(eksEndpoints(), other.eksEndpoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedEndpointConfiguration").add("AutoScalingGroups", autoScalingGroups())
                .add("EksEndpoints", eksEndpoints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoScalingGroups":
            return Optional.ofNullable(clazz.cast(autoScalingGroups()));
        case "eksEndpoints":
            return Optional.ofNullable(clazz.cast(eksEndpoints()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #autoScalingGroups()} initialized to the given value.
     *
     * <p>
     * Describes the configuration of an auto scaling group.
     * </p>
     * 
     * @param autoScalingGroups
     *        Describes the configuration of an auto scaling group.
     */
    public static ManagedEndpointConfiguration fromAutoScalingGroups(AutoScalingGroupsConfiguration autoScalingGroups) {
        return builder().autoScalingGroups(autoScalingGroups).build();
    }

    /**
     * Create an instance of this class with {@link #autoScalingGroups()} initialized to the given value.
     *
     * <p>
     * Describes the configuration of an auto scaling group.
     * </p>
     * 
     * @param autoScalingGroups
     *        Describes the configuration of an auto scaling group.
     */
    public static ManagedEndpointConfiguration fromAutoScalingGroups(
            Consumer<AutoScalingGroupsConfiguration.Builder> autoScalingGroups) {
        AutoScalingGroupsConfiguration.Builder builder = AutoScalingGroupsConfiguration.builder();
        autoScalingGroups.accept(builder);
        return fromAutoScalingGroups(builder.build());
    }

    /**
     * Create an instance of this class with {@link #eksEndpoints()} initialized to the given value.
     *
     * <p>
     * Describes the configuration of an Amazon Elastic Kubernetes Service endpoint.
     * </p>
     * 
     * @param eksEndpoints
     *        Describes the configuration of an Amazon Elastic Kubernetes Service endpoint.
     */
    public static ManagedEndpointConfiguration fromEksEndpoints(EksEndpointsConfiguration eksEndpoints) {
        return builder().eksEndpoints(eksEndpoints).build();
    }

    /**
     * Create an instance of this class with {@link #eksEndpoints()} initialized to the given value.
     *
     * <p>
     * Describes the configuration of an Amazon Elastic Kubernetes Service endpoint.
     * </p>
     * 
     * @param eksEndpoints
     *        Describes the configuration of an Amazon Elastic Kubernetes Service endpoint.
     */
    public static ManagedEndpointConfiguration fromEksEndpoints(Consumer<EksEndpointsConfiguration.Builder> eksEndpoints) {
        EksEndpointsConfiguration.Builder builder = EksEndpointsConfiguration.builder();
        eksEndpoints.accept(builder);
        return fromEksEndpoints(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("autoScalingGroups", AUTO_SCALING_GROUPS_FIELD);
        map.put("eksEndpoints", EKS_ENDPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedEndpointConfiguration, T> g) {
        return obj -> g.apply((ManagedEndpointConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedEndpointConfiguration> {
        /**
         * <p>
         * Describes the configuration of an auto scaling group.
         * </p>
         * 
         * @param autoScalingGroups
         *        Describes the configuration of an auto scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(AutoScalingGroupsConfiguration autoScalingGroups);

        /**
         * <p>
         * Describes the configuration of an auto scaling group.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingGroupsConfiguration.Builder}
         * avoiding the need to create one manually via {@link AutoScalingGroupsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoScalingGroupsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #autoScalingGroups(AutoScalingGroupsConfiguration)}.
         * 
         * @param autoScalingGroups
         *        a consumer that will call methods on {@link AutoScalingGroupsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingGroups(AutoScalingGroupsConfiguration)
         */
        default Builder autoScalingGroups(Consumer<AutoScalingGroupsConfiguration.Builder> autoScalingGroups) {
            return autoScalingGroups(AutoScalingGroupsConfiguration.builder().applyMutation(autoScalingGroups).build());
        }

        /**
         * <p>
         * Describes the configuration of an Amazon Elastic Kubernetes Service endpoint.
         * </p>
         * 
         * @param eksEndpoints
         *        Describes the configuration of an Amazon Elastic Kubernetes Service endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksEndpoints(EksEndpointsConfiguration eksEndpoints);

        /**
         * <p>
         * Describes the configuration of an Amazon Elastic Kubernetes Service endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksEndpointsConfiguration.Builder}
         * avoiding the need to create one manually via {@link EksEndpointsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksEndpointsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #eksEndpoints(EksEndpointsConfiguration)}.
         * 
         * @param eksEndpoints
         *        a consumer that will call methods on {@link EksEndpointsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eksEndpoints(EksEndpointsConfiguration)
         */
        default Builder eksEndpoints(Consumer<EksEndpointsConfiguration.Builder> eksEndpoints) {
            return eksEndpoints(EksEndpointsConfiguration.builder().applyMutation(eksEndpoints).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutoScalingGroupsConfiguration autoScalingGroups;

        private EksEndpointsConfiguration eksEndpoints;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedEndpointConfiguration model) {
            autoScalingGroups(model.autoScalingGroups);
            eksEndpoints(model.eksEndpoints);
        }

        public final AutoScalingGroupsConfiguration.Builder getAutoScalingGroups() {
            return autoScalingGroups != null ? autoScalingGroups.toBuilder() : null;
        }

        public final void setAutoScalingGroups(AutoScalingGroupsConfiguration.BuilderImpl autoScalingGroups) {
            Object oldValue = this.autoScalingGroups;
            this.autoScalingGroups = autoScalingGroups != null ? autoScalingGroups.build() : null;
            handleUnionValueChange(Type.AUTO_SCALING_GROUPS, oldValue, this.autoScalingGroups);
        }

        @Override
        public final Builder autoScalingGroups(AutoScalingGroupsConfiguration autoScalingGroups) {
            Object oldValue = this.autoScalingGroups;
            this.autoScalingGroups = autoScalingGroups;
            handleUnionValueChange(Type.AUTO_SCALING_GROUPS, oldValue, this.autoScalingGroups);
            return this;
        }

        public final EksEndpointsConfiguration.Builder getEksEndpoints() {
            return eksEndpoints != null ? eksEndpoints.toBuilder() : null;
        }

        public final void setEksEndpoints(EksEndpointsConfiguration.BuilderImpl eksEndpoints) {
            Object oldValue = this.eksEndpoints;
            this.eksEndpoints = eksEndpoints != null ? eksEndpoints.build() : null;
            handleUnionValueChange(Type.EKS_ENDPOINTS, oldValue, this.eksEndpoints);
        }

        @Override
        public final Builder eksEndpoints(EksEndpointsConfiguration eksEndpoints) {
            Object oldValue = this.eksEndpoints;
            this.eksEndpoints = eksEndpoints;
            handleUnionValueChange(Type.EKS_ENDPOINTS, oldValue, this.eksEndpoints);
            return this;
        }

        @Override
        public ManagedEndpointConfiguration build() {
            return new ManagedEndpointConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ManagedEndpointConfiguration#type()
     */
    public enum Type {
        AUTO_SCALING_GROUPS,

        EKS_ENDPOINTS,

        UNKNOWN_TO_SDK_VERSION
    }
}
