/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResponderGatewayRequest extends RtbFabricRequest implements
        ToCopyableBuilder<CreateResponderGatewayRequest.Builder, CreateResponderGatewayRequest> {
    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vpcId")
            .getter(getter(CreateResponderGatewayRequest::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(CreateResponderGatewayRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(CreateResponderGatewayRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(CreateResponderGatewayRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(CreateResponderGatewayRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(CreateResponderGatewayRequest::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<TrustStoreConfiguration> TRUST_STORE_CONFIGURATION_FIELD = SdkField
            .<TrustStoreConfiguration> builder(MarshallingType.SDK_POJO).memberName("trustStoreConfiguration")
            .getter(getter(CreateResponderGatewayRequest::trustStoreConfiguration))
            .setter(setter(Builder::trustStoreConfiguration)).constructor(TrustStoreConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustStoreConfiguration").build())
            .build();

    private static final SdkField<ManagedEndpointConfiguration> MANAGED_ENDPOINT_CONFIGURATION_FIELD = SdkField
            .<ManagedEndpointConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("managedEndpointConfiguration")
            .getter(getter(CreateResponderGatewayRequest::managedEndpointConfiguration))
            .setter(setter(Builder::managedEndpointConfiguration))
            .constructor(ManagedEndpointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedEndpointConfiguration")
                    .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateResponderGatewayRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateResponderGatewayRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateResponderGatewayRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ID_FIELD,
            SUBNET_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, DOMAIN_NAME_FIELD, PORT_FIELD, PROTOCOL_FIELD,
            TRUST_STORE_CONFIGURATION_FIELD, MANAGED_ENDPOINT_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vpcId;

    private final List<String> subnetIds;

    private final List<String> securityGroupIds;

    private final String domainName;

    private final Integer port;

    private final String protocol;

    private final TrustStoreConfiguration trustStoreConfiguration;

    private final ManagedEndpointConfiguration managedEndpointConfiguration;

    private final String clientToken;

    private final String description;

    private final Map<String, String> tags;

    private CreateResponderGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.vpcId = builder.vpcId;
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.domainName = builder.domainName;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.trustStoreConfiguration = builder.trustStoreConfiguration;
        this.managedEndpointConfiguration = builder.managedEndpointConfiguration;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier of the Virtual Private Cloud (VPC).
     * </p>
     * 
     * @return The unique identifier of the Virtual Private Cloud (VPC).
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifiers of the subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The unique identifiers of the subnets.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifiers of the security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The unique identifiers of the security groups.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The domain name for the responder gateway.
     * </p>
     * 
     * @return The domain name for the responder gateway.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The networking port to use.
     * </p>
     * 
     * @return The networking port to use.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The networking protocol to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The networking protocol to use.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * <p>
     * The networking protocol to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The networking protocol to use.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The configuration of the trust store.
     * </p>
     * 
     * @return The configuration of the trust store.
     */
    public final TrustStoreConfiguration trustStoreConfiguration() {
        return trustStoreConfiguration;
    }

    /**
     * <p>
     * The configuration for the managed endpoint.
     * </p>
     * 
     * @return The configuration for the managed endpoint.
     */
    public final ManagedEndpointConfiguration managedEndpointConfiguration() {
        return managedEndpointConfiguration;
    }

    /**
     * <p>
     * The unique client token.
     * </p>
     * 
     * @return The unique client token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * An optional description for the responder gateway.
     * </p>
     * 
     * @return An optional description for the responder gateway.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the key-value pairs of the tag or tags to assign to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of the key-value pairs of the tag or tags to assign to the resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(managedEndpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResponderGatewayRequest)) {
            return false;
        }
        CreateResponderGatewayRequest other = (CreateResponderGatewayRequest) obj;
        return Objects.equals(vpcId(), other.vpcId()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(port(), other.port())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(trustStoreConfiguration(), other.trustStoreConfiguration())
                && Objects.equals(managedEndpointConfiguration(), other.managedEndpointConfiguration())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResponderGatewayRequest").add("VpcId", vpcId())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).add("DomainName", domainName())
                .add("Port", port()).add("Protocol", protocolAsString())
                .add("TrustStoreConfiguration", trustStoreConfiguration())
                .add("ManagedEndpointConfiguration", managedEndpointConfiguration()).add("ClientToken", clientToken())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "trustStoreConfiguration":
            return Optional.ofNullable(clazz.cast(trustStoreConfiguration()));
        case "managedEndpointConfiguration":
            return Optional.ofNullable(clazz.cast(managedEndpointConfiguration()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vpcId", VPC_ID_FIELD);
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("port", PORT_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("trustStoreConfiguration", TRUST_STORE_CONFIGURATION_FIELD);
        map.put("managedEndpointConfiguration", MANAGED_ENDPOINT_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResponderGatewayRequest, T> g) {
        return obj -> g.apply((CreateResponderGatewayRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RtbFabricRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateResponderGatewayRequest> {
        /**
         * <p>
         * The unique identifier of the Virtual Private Cloud (VPC).
         * </p>
         * 
         * @param vpcId
         *        The unique identifier of the Virtual Private Cloud (VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The unique identifiers of the subnets.
         * </p>
         * 
         * @param subnetIds
         *        The unique identifiers of the subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The unique identifiers of the subnets.
         * </p>
         * 
         * @param subnetIds
         *        The unique identifiers of the subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The unique identifiers of the security groups.
         * </p>
         * 
         * @param securityGroupIds
         *        The unique identifiers of the security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The unique identifiers of the security groups.
         * </p>
         * 
         * @param securityGroupIds
         *        The unique identifiers of the security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The domain name for the responder gateway.
         * </p>
         * 
         * @param domainName
         *        The domain name for the responder gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The networking port to use.
         * </p>
         * 
         * @param port
         *        The networking port to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The networking protocol to use.
         * </p>
         * 
         * @param protocol
         *        The networking protocol to use.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The networking protocol to use.
         * </p>
         * 
         * @param protocol
         *        The networking protocol to use.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * <p>
         * The configuration of the trust store.
         * </p>
         * 
         * @param trustStoreConfiguration
         *        The configuration of the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreConfiguration(TrustStoreConfiguration trustStoreConfiguration);

        /**
         * <p>
         * The configuration of the trust store.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrustStoreConfiguration.Builder} avoiding
         * the need to create one manually via {@link TrustStoreConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrustStoreConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #trustStoreConfiguration(TrustStoreConfiguration)}.
         * 
         * @param trustStoreConfiguration
         *        a consumer that will call methods on {@link TrustStoreConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustStoreConfiguration(TrustStoreConfiguration)
         */
        default Builder trustStoreConfiguration(Consumer<TrustStoreConfiguration.Builder> trustStoreConfiguration) {
            return trustStoreConfiguration(TrustStoreConfiguration.builder().applyMutation(trustStoreConfiguration).build());
        }

        /**
         * <p>
         * The configuration for the managed endpoint.
         * </p>
         * 
         * @param managedEndpointConfiguration
         *        The configuration for the managed endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedEndpointConfiguration(ManagedEndpointConfiguration managedEndpointConfiguration);

        /**
         * <p>
         * The configuration for the managed endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedEndpointConfiguration.Builder}
         * avoiding the need to create one manually via {@link ManagedEndpointConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedEndpointConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #managedEndpointConfiguration(ManagedEndpointConfiguration)}.
         * 
         * @param managedEndpointConfiguration
         *        a consumer that will call methods on {@link ManagedEndpointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedEndpointConfiguration(ManagedEndpointConfiguration)
         */
        default Builder managedEndpointConfiguration(Consumer<ManagedEndpointConfiguration.Builder> managedEndpointConfiguration) {
            return managedEndpointConfiguration(ManagedEndpointConfiguration.builder()
                    .applyMutation(managedEndpointConfiguration).build());
        }

        /**
         * <p>
         * The unique client token.
         * </p>
         * 
         * @param clientToken
         *        The unique client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * An optional description for the responder gateway.
         * </p>
         * 
         * @param description
         *        An optional description for the responder gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A map of the key-value pairs of the tag or tags to assign to the resource.
         * </p>
         * 
         * @param tags
         *        A map of the key-value pairs of the tag or tags to assign to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RtbFabricRequest.BuilderImpl implements Builder {
        private String vpcId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String domainName;

        private Integer port;

        private String protocol;

        private TrustStoreConfiguration trustStoreConfiguration;

        private ManagedEndpointConfiguration managedEndpointConfiguration;

        private String clientToken;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResponderGatewayRequest model) {
            super(model);
            vpcId(model.vpcId);
            subnetIds(model.subnetIds);
            securityGroupIds(model.securityGroupIds);
            domainName(model.domainName);
            port(model.port);
            protocol(model.protocol);
            trustStoreConfiguration(model.trustStoreConfiguration);
            managedEndpointConfiguration(model.managedEndpointConfiguration);
            clientToken(model.clientToken);
            description(model.description);
            tags(model.tags);
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = CreateResponderGatewayRequestSubnetIdsListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = CreateResponderGatewayRequestSubnetIdsListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = CreateResponderGatewayRequestSecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = CreateResponderGatewayRequestSecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final TrustStoreConfiguration.Builder getTrustStoreConfiguration() {
            return trustStoreConfiguration != null ? trustStoreConfiguration.toBuilder() : null;
        }

        public final void setTrustStoreConfiguration(TrustStoreConfiguration.BuilderImpl trustStoreConfiguration) {
            this.trustStoreConfiguration = trustStoreConfiguration != null ? trustStoreConfiguration.build() : null;
        }

        @Override
        public final Builder trustStoreConfiguration(TrustStoreConfiguration trustStoreConfiguration) {
            this.trustStoreConfiguration = trustStoreConfiguration;
            return this;
        }

        public final ManagedEndpointConfiguration.Builder getManagedEndpointConfiguration() {
            return managedEndpointConfiguration != null ? managedEndpointConfiguration.toBuilder() : null;
        }

        public final void setManagedEndpointConfiguration(ManagedEndpointConfiguration.BuilderImpl managedEndpointConfiguration) {
            this.managedEndpointConfiguration = managedEndpointConfiguration != null ? managedEndpointConfiguration.build()
                    : null;
        }

        @Override
        public final Builder managedEndpointConfiguration(ManagedEndpointConfiguration managedEndpointConfiguration) {
            this.managedEndpointConfiguration = managedEndpointConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResponderGatewayRequest build() {
            return new CreateResponderGatewayRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
