/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a bid action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<NoBidAction> NO_BID_FIELD = SdkField.<NoBidAction> builder(MarshallingType.SDK_POJO)
            .memberName("noBid").getter(getter(Action::noBid)).setter(setter(Builder::noBid)).constructor(NoBidAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noBid").build()).build();

    private static final SdkField<HeaderTagAction> HEADER_TAG_FIELD = SdkField
            .<HeaderTagAction> builder(MarshallingType.SDK_POJO).memberName("headerTag").getter(getter(Action::headerTag))
            .setter(setter(Builder::headerTag)).constructor(HeaderTagAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headerTag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NO_BID_FIELD, HEADER_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NoBidAction noBid;

    private final HeaderTagAction headerTag;

    private final Type type;

    private Action(BuilderImpl builder) {
        this.noBid = builder.noBid;
        this.headerTag = builder.headerTag;
        this.type = builder.type;
    }

    /**
     * <p>
     * Describes a no bid action.
     * </p>
     * 
     * @return Describes a no bid action.
     */
    public final NoBidAction noBid() {
        return noBid;
    }

    /**
     * <p>
     * Describes the header tag for a bid action.
     * </p>
     * 
     * @return Describes the header tag for a bid action.
     */
    public final HeaderTagAction headerTag() {
        return headerTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(noBid());
        hashCode = 31 * hashCode + Objects.hashCode(headerTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(noBid(), other.noBid()) && Objects.equals(headerTag(), other.headerTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Action").add("NoBid", noBid()).add("HeaderTag", headerTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "noBid":
            return Optional.ofNullable(clazz.cast(noBid()));
        case "headerTag":
            return Optional.ofNullable(clazz.cast(headerTag()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #noBid()} initialized to the given value.
     *
     * <p>
     * Describes a no bid action.
     * </p>
     * 
     * @param noBid
     *        Describes a no bid action.
     */
    public static Action fromNoBid(NoBidAction noBid) {
        return builder().noBid(noBid).build();
    }

    /**
     * Create an instance of this class with {@link #noBid()} initialized to the given value.
     *
     * <p>
     * Describes a no bid action.
     * </p>
     * 
     * @param noBid
     *        Describes a no bid action.
     */
    public static Action fromNoBid(Consumer<NoBidAction.Builder> noBid) {
        NoBidAction.Builder builder = NoBidAction.builder();
        noBid.accept(builder);
        return fromNoBid(builder.build());
    }

    /**
     * Create an instance of this class with {@link #headerTag()} initialized to the given value.
     *
     * <p>
     * Describes the header tag for a bid action.
     * </p>
     * 
     * @param headerTag
     *        Describes the header tag for a bid action.
     */
    public static Action fromHeaderTag(HeaderTagAction headerTag) {
        return builder().headerTag(headerTag).build();
    }

    /**
     * Create an instance of this class with {@link #headerTag()} initialized to the given value.
     *
     * <p>
     * Describes the header tag for a bid action.
     * </p>
     * 
     * @param headerTag
     *        Describes the header tag for a bid action.
     */
    public static Action fromHeaderTag(Consumer<HeaderTagAction.Builder> headerTag) {
        HeaderTagAction.Builder builder = HeaderTagAction.builder();
        headerTag.accept(builder);
        return fromHeaderTag(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("noBid", NO_BID_FIELD);
        map.put("headerTag", HEADER_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * Describes a no bid action.
         * </p>
         * 
         * @param noBid
         *        Describes a no bid action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noBid(NoBidAction noBid);

        /**
         * <p>
         * Describes a no bid action.
         * </p>
         * This is a convenience method that creates an instance of the {@link NoBidAction.Builder} avoiding the need to
         * create one manually via {@link NoBidAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NoBidAction.Builder#build()} is called immediately and its result
         * is passed to {@link #noBid(NoBidAction)}.
         * 
         * @param noBid
         *        a consumer that will call methods on {@link NoBidAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noBid(NoBidAction)
         */
        default Builder noBid(Consumer<NoBidAction.Builder> noBid) {
            return noBid(NoBidAction.builder().applyMutation(noBid).build());
        }

        /**
         * <p>
         * Describes the header tag for a bid action.
         * </p>
         * 
         * @param headerTag
         *        Describes the header tag for a bid action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerTag(HeaderTagAction headerTag);

        /**
         * <p>
         * Describes the header tag for a bid action.
         * </p>
         * This is a convenience method that creates an instance of the {@link HeaderTagAction.Builder} avoiding the
         * need to create one manually via {@link HeaderTagAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HeaderTagAction.Builder#build()} is called immediately and its
         * result is passed to {@link #headerTag(HeaderTagAction)}.
         * 
         * @param headerTag
         *        a consumer that will call methods on {@link HeaderTagAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headerTag(HeaderTagAction)
         */
        default Builder headerTag(Consumer<HeaderTagAction.Builder> headerTag) {
            return headerTag(HeaderTagAction.builder().applyMutation(headerTag).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NoBidAction noBid;

        private HeaderTagAction headerTag;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            noBid(model.noBid);
            headerTag(model.headerTag);
        }

        public final NoBidAction.Builder getNoBid() {
            return noBid != null ? noBid.toBuilder() : null;
        }

        public final void setNoBid(NoBidAction.BuilderImpl noBid) {
            Object oldValue = this.noBid;
            this.noBid = noBid != null ? noBid.build() : null;
            handleUnionValueChange(Type.NO_BID, oldValue, this.noBid);
        }

        @Override
        public final Builder noBid(NoBidAction noBid) {
            Object oldValue = this.noBid;
            this.noBid = noBid;
            handleUnionValueChange(Type.NO_BID, oldValue, this.noBid);
            return this;
        }

        public final HeaderTagAction.Builder getHeaderTag() {
            return headerTag != null ? headerTag.toBuilder() : null;
        }

        public final void setHeaderTag(HeaderTagAction.BuilderImpl headerTag) {
            Object oldValue = this.headerTag;
            this.headerTag = headerTag != null ? headerTag.build() : null;
            handleUnionValueChange(Type.HEADER_TAG, oldValue, this.headerTag);
        }

        @Override
        public final Builder headerTag(HeaderTagAction headerTag) {
            Object oldValue = this.headerTag;
            this.headerTag = headerTag;
            handleUnionValueChange(Type.HEADER_TAG, oldValue, this.headerTag);
            return this;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Action#type()
     */
    public enum Type {
        NO_BID,

        HEADER_TAG,

        UNKNOWN_TO_SDK_VERSION
    }
}
