/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rtbfabric.model.AutoScalingGroupsConfiguration;
import software.amazon.awssdk.services.rtbfabric.model.EksEndpointsConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedEndpointConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedEndpointConfiguration> {
    private static final SdkField<AutoScalingGroupsConfiguration> AUTO_SCALING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoScalingGroups").getter(ManagedEndpointConfiguration.getter(ManagedEndpointConfiguration::autoScalingGroups)).setter(ManagedEndpointConfiguration.setter(Builder::autoScalingGroups)).constructor(AutoScalingGroupsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroups").build()}).build();
    private static final SdkField<EksEndpointsConfiguration> EKS_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eksEndpoints").getter(ManagedEndpointConfiguration.getter(ManagedEndpointConfiguration::eksEndpoints)).setter(ManagedEndpointConfiguration.setter(Builder::eksEndpoints)).constructor(EksEndpointsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksEndpoints").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUPS_FIELD, EKS_ENDPOINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedEndpointConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutoScalingGroupsConfiguration autoScalingGroups;
    private final EksEndpointsConfiguration eksEndpoints;
    private final Type type;

    private ManagedEndpointConfiguration(BuilderImpl builder) {
        this.autoScalingGroups = builder.autoScalingGroups;
        this.eksEndpoints = builder.eksEndpoints;
        this.type = builder.type;
    }

    public final AutoScalingGroupsConfiguration autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public final EksEndpointsConfiguration eksEndpoints() {
        return this.eksEndpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.eksEndpoints());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedEndpointConfiguration)) {
            return false;
        }
        ManagedEndpointConfiguration other = (ManagedEndpointConfiguration)obj;
        return Objects.equals(this.autoScalingGroups(), other.autoScalingGroups()) && Objects.equals(this.eksEndpoints(), other.eksEndpoints());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedEndpointConfiguration").add("AutoScalingGroups", (Object)this.autoScalingGroups()).add("EksEndpoints", (Object)this.eksEndpoints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autoScalingGroups": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroups()));
            }
            case "eksEndpoints": {
                return Optional.ofNullable(clazz.cast(this.eksEndpoints()));
            }
        }
        return Optional.empty();
    }

    public static ManagedEndpointConfiguration fromAutoScalingGroups(AutoScalingGroupsConfiguration autoScalingGroups) {
        return (ManagedEndpointConfiguration)ManagedEndpointConfiguration.builder().autoScalingGroups(autoScalingGroups).build();
    }

    public static ManagedEndpointConfiguration fromAutoScalingGroups(Consumer<AutoScalingGroupsConfiguration.Builder> autoScalingGroups) {
        AutoScalingGroupsConfiguration.Builder builder = AutoScalingGroupsConfiguration.builder();
        autoScalingGroups.accept(builder);
        return ManagedEndpointConfiguration.fromAutoScalingGroups((AutoScalingGroupsConfiguration)builder.build());
    }

    public static ManagedEndpointConfiguration fromEksEndpoints(EksEndpointsConfiguration eksEndpoints) {
        return (ManagedEndpointConfiguration)ManagedEndpointConfiguration.builder().eksEndpoints(eksEndpoints).build();
    }

    public static ManagedEndpointConfiguration fromEksEndpoints(Consumer<EksEndpointsConfiguration.Builder> eksEndpoints) {
        EksEndpointsConfiguration.Builder builder = EksEndpointsConfiguration.builder();
        eksEndpoints.accept(builder);
        return ManagedEndpointConfiguration.fromEksEndpoints((EksEndpointsConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("autoScalingGroups", AUTO_SCALING_GROUPS_FIELD);
        map.put("eksEndpoints", EKS_ENDPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedEndpointConfiguration, T> g) {
        return obj -> g.apply((ManagedEndpointConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AUTO_SCALING_GROUPS,
        EKS_ENDPOINTS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AutoScalingGroupsConfiguration autoScalingGroups;
        private EksEndpointsConfiguration eksEndpoints;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedEndpointConfiguration model) {
            this.autoScalingGroups(model.autoScalingGroups);
            this.eksEndpoints(model.eksEndpoints);
        }

        public final AutoScalingGroupsConfiguration.Builder getAutoScalingGroups() {
            return this.autoScalingGroups != null ? this.autoScalingGroups.toBuilder() : null;
        }

        public final void setAutoScalingGroups(AutoScalingGroupsConfiguration.BuilderImpl autoScalingGroups) {
            AutoScalingGroupsConfiguration oldValue = this.autoScalingGroups;
            this.autoScalingGroups = autoScalingGroups != null ? autoScalingGroups.build() : null;
            this.handleUnionValueChange(Type.AUTO_SCALING_GROUPS, oldValue, this.autoScalingGroups);
        }

        @Override
        public final Builder autoScalingGroups(AutoScalingGroupsConfiguration autoScalingGroups) {
            AutoScalingGroupsConfiguration oldValue = this.autoScalingGroups;
            this.autoScalingGroups = autoScalingGroups;
            this.handleUnionValueChange(Type.AUTO_SCALING_GROUPS, oldValue, this.autoScalingGroups);
            return this;
        }

        public final EksEndpointsConfiguration.Builder getEksEndpoints() {
            return this.eksEndpoints != null ? this.eksEndpoints.toBuilder() : null;
        }

        public final void setEksEndpoints(EksEndpointsConfiguration.BuilderImpl eksEndpoints) {
            EksEndpointsConfiguration oldValue = this.eksEndpoints;
            this.eksEndpoints = eksEndpoints != null ? eksEndpoints.build() : null;
            this.handleUnionValueChange(Type.EKS_ENDPOINTS, oldValue, this.eksEndpoints);
        }

        @Override
        public final Builder eksEndpoints(EksEndpointsConfiguration eksEndpoints) {
            EksEndpointsConfiguration oldValue = this.eksEndpoints;
            this.eksEndpoints = eksEndpoints;
            this.handleUnionValueChange(Type.EKS_ENDPOINTS, oldValue, this.eksEndpoints);
            return this;
        }

        public ManagedEndpointConfiguration build() {
            return new ManagedEndpointConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedEndpointConfiguration> {
        public Builder autoScalingGroups(AutoScalingGroupsConfiguration var1);

        default public Builder autoScalingGroups(Consumer<AutoScalingGroupsConfiguration.Builder> autoScalingGroups) {
            return this.autoScalingGroups((AutoScalingGroupsConfiguration)((AutoScalingGroupsConfiguration.Builder)AutoScalingGroupsConfiguration.builder().applyMutation(autoScalingGroups)).build());
        }

        public Builder eksEndpoints(EksEndpointsConfiguration var1);

        default public Builder eksEndpoints(Consumer<EksEndpointsConfiguration.Builder> eksEndpoints) {
            return this.eksEndpoints((EksEndpointsConfiguration)((EksEndpointsConfiguration.Builder)EksEndpointsConfiguration.builder().applyMutation(eksEndpoints)).build());
        }
    }
}

