/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IpAddressStatus {
    CREATING("CREATING"),
    FAILED_CREATION("FAILED_CREATION"),
    ATTACHING("ATTACHING"),
    ATTACHED("ATTACHED"),
    REMAP_DETACHING("REMAP_DETACHING"),
    REMAP_ATTACHING("REMAP_ATTACHING"),
    DETACHING("DETACHING"),
    FAILED_RESOURCE_GONE("FAILED_RESOURCE_GONE"),
    DELETING("DELETING"),
    DELETE_FAILED_FAS_EXPIRED("DELETE_FAILED_FAS_EXPIRED"),
    UPDATING("UPDATING"),
    UPDATE_FAILED("UPDATE_FAILED"),
    ISOLATED("ISOLATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IpAddressStatus> VALUE_MAP;
    private final String value;

    private IpAddressStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpAddressStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpAddressStatus> knownValues() {
        EnumSet<IpAddressStatus> knownValues = EnumSet.allOf(IpAddressStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IpAddressStatus.class, IpAddressStatus::toString);
    }
}

