/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverAsyncClient;
import software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociation;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsResponse;

public class ListFirewallRuleGroupAssociationsPublisher
implements SdkPublisher<ListFirewallRuleGroupAssociationsResponse> {
    private final Route53ResolverAsyncClient client;
    private final ListFirewallRuleGroupAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFirewallRuleGroupAssociationsPublisher(Route53ResolverAsyncClient client, ListFirewallRuleGroupAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFirewallRuleGroupAssociationsPublisher(Route53ResolverAsyncClient client, ListFirewallRuleGroupAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFirewallRuleGroupAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFirewallRuleGroupAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FirewallRuleGroupAssociation> firewallRuleGroupAssociations() {
        Function<ListFirewallRuleGroupAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.firewallRuleGroupAssociations() != null) {
                return response.firewallRuleGroupAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFirewallRuleGroupAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFirewallRuleGroupAssociationsResponseFetcher
    implements AsyncPageFetcher<ListFirewallRuleGroupAssociationsResponse> {
        private ListFirewallRuleGroupAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallRuleGroupAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFirewallRuleGroupAssociationsResponse> nextPage(ListFirewallRuleGroupAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallRuleGroupAssociationsPublisher.this.client.listFirewallRuleGroupAssociations(ListFirewallRuleGroupAssociationsPublisher.this.firstRequest);
            }
            return ListFirewallRuleGroupAssociationsPublisher.this.client.listFirewallRuleGroupAssociations((ListFirewallRuleGroupAssociationsRequest)((Object)ListFirewallRuleGroupAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

