/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResolverEndpointRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<UpdateResolverEndpointRequest.Builder, UpdateResolverEndpointRequest> {
    private static final SdkField<String> RESOLVER_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResolverEndpointId").getter(getter(UpdateResolverEndpointRequest::resolverEndpointId))
            .setter(setter(Builder::resolverEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpointId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateResolverEndpointRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RESOLVER_ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResolverEndpointType").getter(getter(UpdateResolverEndpointRequest::resolverEndpointTypeAsString))
            .setter(setter(Builder::resolverEndpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpointType").build())
            .build();

    private static final SdkField<List<UpdateIpAddress>> UPDATE_IP_ADDRESSES_FIELD = SdkField
            .<List<UpdateIpAddress>> builder(MarshallingType.LIST)
            .memberName("UpdateIpAddresses")
            .getter(getter(UpdateResolverEndpointRequest::updateIpAddresses))
            .setter(setter(Builder::updateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateIpAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateIpAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_ENDPOINT_ID_FIELD,
            NAME_FIELD, RESOLVER_ENDPOINT_TYPE_FIELD, UPDATE_IP_ADDRESSES_FIELD));

    private final String resolverEndpointId;

    private final String name;

    private final String resolverEndpointType;

    private final List<UpdateIpAddress> updateIpAddresses;

    private UpdateResolverEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.resolverEndpointId = builder.resolverEndpointId;
        this.name = builder.name;
        this.resolverEndpointType = builder.resolverEndpointType;
        this.updateIpAddresses = builder.updateIpAddresses;
    }

    /**
     * <p>
     * The ID of the Resolver endpoint that you want to update.
     * </p>
     * 
     * @return The ID of the Resolver endpoint that you want to update.
     */
    public final String resolverEndpointId() {
        return resolverEndpointId;
    }

    /**
     * <p>
     * The name of the Resolver endpoint that you want to update.
     * </p>
     * 
     * @return The name of the Resolver endpoint that you want to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the endpoint type for what type of IP address the endpoint uses to forward DNS queries.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resolverEndpointType} will return {@link ResolverEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resolverEndpointTypeAsString}.
     * </p>
     * 
     * @return Specifies the endpoint type for what type of IP address the endpoint uses to forward DNS queries.
     * @see ResolverEndpointType
     */
    public final ResolverEndpointType resolverEndpointType() {
        return ResolverEndpointType.fromValue(resolverEndpointType);
    }

    /**
     * <p>
     * Specifies the endpoint type for what type of IP address the endpoint uses to forward DNS queries.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resolverEndpointType} will return {@link ResolverEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resolverEndpointTypeAsString}.
     * </p>
     * 
     * @return Specifies the endpoint type for what type of IP address the endpoint uses to forward DNS queries.
     * @see ResolverEndpointType
     */
    public final String resolverEndpointTypeAsString() {
        return resolverEndpointType;
    }

    /**
     * For responses, this returns true if the service returned a value for the UpdateIpAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUpdateIpAddresses() {
        return updateIpAddresses != null && !(updateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Updates the Resolver endpoint type to IpV4, Ipv6, or dual-stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdateIpAddresses} method.
     * </p>
     * 
     * @return Updates the Resolver endpoint type to IpV4, Ipv6, or dual-stack.
     */
    public final List<UpdateIpAddress> updateIpAddresses() {
        return updateIpAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolverEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resolverEndpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdateIpAddresses() ? updateIpAddresses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResolverEndpointRequest)) {
            return false;
        }
        UpdateResolverEndpointRequest other = (UpdateResolverEndpointRequest) obj;
        return Objects.equals(resolverEndpointId(), other.resolverEndpointId()) && Objects.equals(name(), other.name())
                && Objects.equals(resolverEndpointTypeAsString(), other.resolverEndpointTypeAsString())
                && hasUpdateIpAddresses() == other.hasUpdateIpAddresses()
                && Objects.equals(updateIpAddresses(), other.updateIpAddresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResolverEndpointRequest").add("ResolverEndpointId", resolverEndpointId())
                .add("Name", name()).add("ResolverEndpointType", resolverEndpointTypeAsString())
                .add("UpdateIpAddresses", hasUpdateIpAddresses() ? updateIpAddresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResolverEndpointId":
            return Optional.ofNullable(clazz.cast(resolverEndpointId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ResolverEndpointType":
            return Optional.ofNullable(clazz.cast(resolverEndpointTypeAsString()));
        case "UpdateIpAddresses":
            return Optional.ofNullable(clazz.cast(updateIpAddresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResolverEndpointRequest, T> g) {
        return obj -> g.apply((UpdateResolverEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateResolverEndpointRequest> {
        /**
         * <p>
         * The ID of the Resolver endpoint that you want to update.
         * </p>
         * 
         * @param resolverEndpointId
         *        The ID of the Resolver endpoint that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverEndpointId(String resolverEndpointId);

        /**
         * <p>
         * The name of the Resolver endpoint that you want to update.
         * </p>
         * 
         * @param name
         *        The name of the Resolver endpoint that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the endpoint type for what type of IP address the endpoint uses to forward DNS queries.
         * </p>
         * 
         * @param resolverEndpointType
         *        Specifies the endpoint type for what type of IP address the endpoint uses to forward DNS queries.
         * @see ResolverEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverEndpointType
         */
        Builder resolverEndpointType(String resolverEndpointType);

        /**
         * <p>
         * Specifies the endpoint type for what type of IP address the endpoint uses to forward DNS queries.
         * </p>
         * 
         * @param resolverEndpointType
         *        Specifies the endpoint type for what type of IP address the endpoint uses to forward DNS queries.
         * @see ResolverEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverEndpointType
         */
        Builder resolverEndpointType(ResolverEndpointType resolverEndpointType);

        /**
         * <p>
         * Updates the Resolver endpoint type to IpV4, Ipv6, or dual-stack.
         * </p>
         * 
         * @param updateIpAddresses
         *        Updates the Resolver endpoint type to IpV4, Ipv6, or dual-stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateIpAddresses(Collection<UpdateIpAddress> updateIpAddresses);

        /**
         * <p>
         * Updates the Resolver endpoint type to IpV4, Ipv6, or dual-stack.
         * </p>
         * 
         * @param updateIpAddresses
         *        Updates the Resolver endpoint type to IpV4, Ipv6, or dual-stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateIpAddresses(UpdateIpAddress... updateIpAddresses);

        /**
         * <p>
         * Updates the Resolver endpoint type to IpV4, Ipv6, or dual-stack.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53resolver.model.UpdateIpAddress.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.route53resolver.model.UpdateIpAddress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53resolver.model.UpdateIpAddress.Builder#build()} is called
         * immediately and its result is passed to {@link #updateIpAddresses(List<UpdateIpAddress>)}.
         * 
         * @param updateIpAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53resolver.model.UpdateIpAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateIpAddresses(java.util.Collection<UpdateIpAddress>)
         */
        Builder updateIpAddresses(Consumer<UpdateIpAddress.Builder>... updateIpAddresses);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String resolverEndpointId;

        private String name;

        private String resolverEndpointType;

        private List<UpdateIpAddress> updateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResolverEndpointRequest model) {
            super(model);
            resolverEndpointId(model.resolverEndpointId);
            name(model.name);
            resolverEndpointType(model.resolverEndpointType);
            updateIpAddresses(model.updateIpAddresses);
        }

        public final String getResolverEndpointId() {
            return resolverEndpointId;
        }

        public final void setResolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
        }

        @Override
        public final Builder resolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResolverEndpointType() {
            return resolverEndpointType;
        }

        public final void setResolverEndpointType(String resolverEndpointType) {
            this.resolverEndpointType = resolverEndpointType;
        }

        @Override
        public final Builder resolverEndpointType(String resolverEndpointType) {
            this.resolverEndpointType = resolverEndpointType;
            return this;
        }

        @Override
        public final Builder resolverEndpointType(ResolverEndpointType resolverEndpointType) {
            this.resolverEndpointType(resolverEndpointType == null ? null : resolverEndpointType.toString());
            return this;
        }

        public final List<UpdateIpAddress.Builder> getUpdateIpAddresses() {
            List<UpdateIpAddress.Builder> result = UpdateIpAddressesCopier.copyToBuilder(this.updateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdateIpAddresses(Collection<UpdateIpAddress.BuilderImpl> updateIpAddresses) {
            this.updateIpAddresses = UpdateIpAddressesCopier.copyFromBuilder(updateIpAddresses);
        }

        @Override
        public final Builder updateIpAddresses(Collection<UpdateIpAddress> updateIpAddresses) {
            this.updateIpAddresses = UpdateIpAddressesCopier.copy(updateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateIpAddresses(UpdateIpAddress... updateIpAddresses) {
            updateIpAddresses(Arrays.asList(updateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateIpAddresses(Consumer<UpdateIpAddress.Builder>... updateIpAddresses) {
            updateIpAddresses(Stream.of(updateIpAddresses).map(c -> UpdateIpAddress.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResolverEndpointRequest build() {
            return new UpdateResolverEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
