/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverAsyncClient;
import software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupMetadata;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsResponse;

public class ListFirewallRuleGroupsPublisher
implements SdkPublisher<ListFirewallRuleGroupsResponse> {
    private final Route53ResolverAsyncClient client;
    private final ListFirewallRuleGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFirewallRuleGroupsPublisher(Route53ResolverAsyncClient client, ListFirewallRuleGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFirewallRuleGroupsPublisher(Route53ResolverAsyncClient client, ListFirewallRuleGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFirewallRuleGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFirewallRuleGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FirewallRuleGroupMetadata> firewallRuleGroups() {
        Function<ListFirewallRuleGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.firewallRuleGroups() != null) {
                return response.firewallRuleGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFirewallRuleGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFirewallRuleGroupsResponseFetcher
    implements AsyncPageFetcher<ListFirewallRuleGroupsResponse> {
        private ListFirewallRuleGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallRuleGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFirewallRuleGroupsResponse> nextPage(ListFirewallRuleGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallRuleGroupsPublisher.this.client.listFirewallRuleGroups(ListFirewallRuleGroupsPublisher.this.firstRequest);
            }
            return ListFirewallRuleGroupsPublisher.this.client.listFirewallRuleGroups((ListFirewallRuleGroupsRequest)((Object)ListFirewallRuleGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

