/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.TargetAddress;
import software.amazon.awssdk.services.route53resolver.model.TargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolverRuleConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResolverRuleConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ResolverRuleConfig.getter(ResolverRuleConfig::name)).setter(ResolverRuleConfig.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<TargetAddress>> TARGET_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetIps").getter(ResolverRuleConfig.getter(ResolverRuleConfig::targetIps)).setter(ResolverRuleConfig.setter(Builder::targetIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOLVER_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResolverEndpointId").getter(ResolverRuleConfig.getter(ResolverRuleConfig::resolverEndpointId)).setter(ResolverRuleConfig.setter(Builder::resolverEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpointId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TARGET_IPS_FIELD, RESOLVER_ENDPOINT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<TargetAddress> targetIps;
    private final String resolverEndpointId;

    private ResolverRuleConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.targetIps = builder.targetIps;
        this.resolverEndpointId = builder.resolverEndpointId;
    }

    public String name() {
        return this.name;
    }

    public boolean hasTargetIps() {
        return this.targetIps != null && !(this.targetIps instanceof SdkAutoConstructList);
    }

    public List<TargetAddress> targetIps() {
        return this.targetIps;
    }

    public String resolverEndpointId() {
        return this.resolverEndpointId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIps());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverEndpointId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolverRuleConfig)) {
            return false;
        }
        ResolverRuleConfig other = (ResolverRuleConfig)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.targetIps(), other.targetIps()) && Objects.equals(this.resolverEndpointId(), other.resolverEndpointId());
    }

    public String toString() {
        return ToString.builder((String)"ResolverRuleConfig").add("Name", (Object)this.name()).add("TargetIps", this.targetIps()).add("ResolverEndpointId", (Object)this.resolverEndpointId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TargetIps": {
                return Optional.ofNullable(clazz.cast(this.targetIps()));
            }
            case "ResolverEndpointId": {
                return Optional.ofNullable(clazz.cast(this.resolverEndpointId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolverRuleConfig, T> g) {
        return obj -> g.apply((ResolverRuleConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<TargetAddress> targetIps = DefaultSdkAutoConstructList.getInstance();
        private String resolverEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolverRuleConfig model) {
            this.name(model.name);
            this.targetIps(model.targetIps);
            this.resolverEndpointId(model.resolverEndpointId);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<TargetAddress.Builder> getTargetIps() {
            return this.targetIps != null ? (Collection)this.targetIps.stream().map(TargetAddress::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetIps(Collection<TargetAddress> targetIps) {
            this.targetIps = TargetListCopier.copy(targetIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIps(TargetAddress ... targetIps) {
            this.targetIps(Arrays.asList(targetIps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIps(Consumer<TargetAddress.Builder> ... targetIps) {
            this.targetIps(Stream.of(targetIps).map(c -> (TargetAddress)((TargetAddress.Builder)TargetAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetIps(Collection<TargetAddress.BuilderImpl> targetIps) {
            this.targetIps = TargetListCopier.copyFromBuilder(targetIps);
        }

        public final String getResolverEndpointId() {
            return this.resolverEndpointId;
        }

        @Override
        public final Builder resolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
            return this;
        }

        public final void setResolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
        }

        public ResolverRuleConfig build() {
            return new ResolverRuleConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResolverRuleConfig> {
        public Builder name(String var1);

        public Builder targetIps(Collection<TargetAddress> var1);

        public Builder targetIps(TargetAddress ... var1);

        public Builder targetIps(Consumer<TargetAddress.Builder> ... var1);

        public Builder resolverEndpointId(String var1);
    }
}

