/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.IpAddressUpdate;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateResolverEndpointIpAddressRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, DisassociateResolverEndpointIpAddressRequest> {
    private static final SdkField<String> RESOLVER_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResolverEndpointId").getter(DisassociateResolverEndpointIpAddressRequest.getter(DisassociateResolverEndpointIpAddressRequest::resolverEndpointId)).setter(DisassociateResolverEndpointIpAddressRequest.setter(Builder::resolverEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpointId").build()}).build();
    private static final SdkField<IpAddressUpdate> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IpAddress").getter(DisassociateResolverEndpointIpAddressRequest.getter(DisassociateResolverEndpointIpAddressRequest::ipAddress)).setter(DisassociateResolverEndpointIpAddressRequest.setter(Builder::ipAddress)).constructor(IpAddressUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_ENDPOINT_ID_FIELD, IP_ADDRESS_FIELD));
    private final String resolverEndpointId;
    private final IpAddressUpdate ipAddress;

    private DisassociateResolverEndpointIpAddressRequest(BuilderImpl builder) {
        super(builder);
        this.resolverEndpointId = builder.resolverEndpointId;
        this.ipAddress = builder.ipAddress;
    }

    public String resolverEndpointId() {
        return this.resolverEndpointId;
    }

    public IpAddressUpdate ipAddress() {
        return this.ipAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateResolverEndpointIpAddressRequest)) {
            return false;
        }
        DisassociateResolverEndpointIpAddressRequest other = (DisassociateResolverEndpointIpAddressRequest)((Object)obj);
        return Objects.equals(this.resolverEndpointId(), other.resolverEndpointId()) && Objects.equals(this.ipAddress(), other.ipAddress());
    }

    public String toString() {
        return ToString.builder((String)"DisassociateResolverEndpointIpAddressRequest").add("ResolverEndpointId", (Object)this.resolverEndpointId()).add("IpAddress", (Object)this.ipAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResolverEndpointId": {
                return Optional.ofNullable(clazz.cast(this.resolverEndpointId()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateResolverEndpointIpAddressRequest, T> g) {
        return obj -> g.apply((DisassociateResolverEndpointIpAddressRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String resolverEndpointId;
        private IpAddressUpdate ipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateResolverEndpointIpAddressRequest model) {
            super(model);
            this.resolverEndpointId(model.resolverEndpointId);
            this.ipAddress(model.ipAddress);
        }

        public final String getResolverEndpointId() {
            return this.resolverEndpointId;
        }

        @Override
        public final Builder resolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
            return this;
        }

        public final void setResolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
        }

        public final IpAddressUpdate.Builder getIpAddress() {
            return this.ipAddress != null ? this.ipAddress.toBuilder() : null;
        }

        @Override
        public final Builder ipAddress(IpAddressUpdate ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(IpAddressUpdate.BuilderImpl ipAddress) {
            this.ipAddress = ipAddress != null ? ipAddress.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateResolverEndpointIpAddressRequest build() {
            return new DisassociateResolverEndpointIpAddressRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateResolverEndpointIpAddressRequest> {
        public Builder resolverEndpointId(String var1);

        public Builder ipAddress(IpAddressUpdate var1);

        default public Builder ipAddress(Consumer<IpAddressUpdate.Builder> ipAddress) {
            return this.ipAddress((IpAddressUpdate)((IpAddressUpdate.Builder)IpAddressUpdate.builder().applyMutation(ipAddress)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

