/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverAsyncClient;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse;

public class ListResolverEndpointIpAddressesPublisher
implements SdkPublisher<ListResolverEndpointIpAddressesResponse> {
    private final Route53ResolverAsyncClient client;
    private final ListResolverEndpointIpAddressesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResolverEndpointIpAddressesPublisher(Route53ResolverAsyncClient client, ListResolverEndpointIpAddressesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResolverEndpointIpAddressesPublisher(Route53ResolverAsyncClient client, ListResolverEndpointIpAddressesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResolverEndpointIpAddressesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResolverEndpointIpAddressesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListResolverEndpointIpAddressesPublisher resume(ListResolverEndpointIpAddressesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListResolverEndpointIpAddressesPublisher(this.client, (ListResolverEndpointIpAddressesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListResolverEndpointIpAddressesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListResolverEndpointIpAddressesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListResolverEndpointIpAddressesResponseFetcher
    implements AsyncPageFetcher<ListResolverEndpointIpAddressesResponse> {
        private ListResolverEndpointIpAddressesResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverEndpointIpAddressesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResolverEndpointIpAddressesResponse> nextPage(ListResolverEndpointIpAddressesResponse previousPage) {
            if (previousPage == null) {
                return ListResolverEndpointIpAddressesPublisher.this.client.listResolverEndpointIpAddresses(ListResolverEndpointIpAddressesPublisher.this.firstRequest);
            }
            return ListResolverEndpointIpAddressesPublisher.this.client.listResolverEndpointIpAddresses((ListResolverEndpointIpAddressesRequest)((Object)ListResolverEndpointIpAddressesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

