/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53profiles;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.route53profiles.Route53ProfilesClient;
import software.amazon.awssdk.services.route53profiles.Route53ProfilesServiceClientConfiguration;
import software.amazon.awssdk.services.route53profiles.internal.Route53ProfilesServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.route53profiles.model.AccessDeniedException;
import software.amazon.awssdk.services.route53profiles.model.AssociateProfileRequest;
import software.amazon.awssdk.services.route53profiles.model.AssociateProfileResponse;
import software.amazon.awssdk.services.route53profiles.model.AssociateResourceToProfileRequest;
import software.amazon.awssdk.services.route53profiles.model.AssociateResourceToProfileResponse;
import software.amazon.awssdk.services.route53profiles.model.ConflictException;
import software.amazon.awssdk.services.route53profiles.model.CreateProfileRequest;
import software.amazon.awssdk.services.route53profiles.model.CreateProfileResponse;
import software.amazon.awssdk.services.route53profiles.model.DeleteProfileRequest;
import software.amazon.awssdk.services.route53profiles.model.DeleteProfileResponse;
import software.amazon.awssdk.services.route53profiles.model.DisassociateProfileRequest;
import software.amazon.awssdk.services.route53profiles.model.DisassociateProfileResponse;
import software.amazon.awssdk.services.route53profiles.model.DisassociateResourceFromProfileRequest;
import software.amazon.awssdk.services.route53profiles.model.DisassociateResourceFromProfileResponse;
import software.amazon.awssdk.services.route53profiles.model.GetProfileAssociationRequest;
import software.amazon.awssdk.services.route53profiles.model.GetProfileAssociationResponse;
import software.amazon.awssdk.services.route53profiles.model.GetProfileRequest;
import software.amazon.awssdk.services.route53profiles.model.GetProfileResourceAssociationRequest;
import software.amazon.awssdk.services.route53profiles.model.GetProfileResourceAssociationResponse;
import software.amazon.awssdk.services.route53profiles.model.GetProfileResponse;
import software.amazon.awssdk.services.route53profiles.model.InternalServiceErrorException;
import software.amazon.awssdk.services.route53profiles.model.InvalidNextTokenException;
import software.amazon.awssdk.services.route53profiles.model.InvalidParameterException;
import software.amazon.awssdk.services.route53profiles.model.LimitExceededException;
import software.amazon.awssdk.services.route53profiles.model.ListProfileAssociationsRequest;
import software.amazon.awssdk.services.route53profiles.model.ListProfileAssociationsResponse;
import software.amazon.awssdk.services.route53profiles.model.ListProfileResourceAssociationsRequest;
import software.amazon.awssdk.services.route53profiles.model.ListProfileResourceAssociationsResponse;
import software.amazon.awssdk.services.route53profiles.model.ListProfilesRequest;
import software.amazon.awssdk.services.route53profiles.model.ListProfilesResponse;
import software.amazon.awssdk.services.route53profiles.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53profiles.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53profiles.model.ResourceExistsException;
import software.amazon.awssdk.services.route53profiles.model.ResourceNotFoundException;
import software.amazon.awssdk.services.route53profiles.model.Route53ProfilesException;
import software.amazon.awssdk.services.route53profiles.model.TagResourceRequest;
import software.amazon.awssdk.services.route53profiles.model.TagResourceResponse;
import software.amazon.awssdk.services.route53profiles.model.ThrottlingException;
import software.amazon.awssdk.services.route53profiles.model.UntagResourceRequest;
import software.amazon.awssdk.services.route53profiles.model.UntagResourceResponse;
import software.amazon.awssdk.services.route53profiles.model.UpdateProfileResourceAssociationRequest;
import software.amazon.awssdk.services.route53profiles.model.UpdateProfileResourceAssociationResponse;
import software.amazon.awssdk.services.route53profiles.model.ValidationException;
import software.amazon.awssdk.services.route53profiles.transform.AssociateProfileRequestMarshaller;
import software.amazon.awssdk.services.route53profiles.transform.AssociateResourceToProfileRequestMarshaller;
import software.amazon.awssdk.services.route53profiles.transform.CreateProfileRequestMarshaller;
import software.amazon.awssdk.services.route53profiles.transform.DeleteProfileRequestMarshaller;
import software.amazon.awssdk.services.route53profiles.transform.DisassociateProfileRequestMarshaller;
import software.amazon.awssdk.services.route53profiles.transform.DisassociateResourceFromProfileRequestMarshaller;
import software.amazon.awssdk.services.route53profiles.transform.GetProfileAssociationRequestMarshaller;
import software.amazon.awssdk.services.route53profiles.transform.GetProfileRequestMarshaller;
import software.amazon.awssdk.services.route53profiles.transform.GetProfileResourceAssociationRequestMarshaller;
import software.amazon.awssdk.services.route53profiles.transform.ListProfileAssociationsRequestMarshaller;
import software.amazon.awssdk.services.route53profiles.transform.ListProfileResourceAssociationsRequestMarshaller;
import software.amazon.awssdk.services.route53profiles.transform.ListProfilesRequestMarshaller;
import software.amazon.awssdk.services.route53profiles.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53profiles.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.route53profiles.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.route53profiles.transform.UpdateProfileResourceAssociationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultRoute53ProfilesClient
implements Route53ProfilesClient {
    private static final Logger log = Logger.loggerFor(DefaultRoute53ProfilesClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRoute53ProfilesClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateProfileResponse associateProfile(AssociateProfileRequest associateProfileRequest) throws ResourceNotFoundException, ResourceExistsException, LimitExceededException, InvalidParameterException, ThrottlingException, ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, associateProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateProfile");
            AssociateProfileResponse associateProfileResponse = (AssociateProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$associateProfile$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateResourceToProfileResponse associateResourceToProfile(AssociateResourceToProfileRequest associateResourceToProfileRequest) throws ResourceNotFoundException, LimitExceededException, InternalServiceErrorException, InvalidParameterException, ThrottlingException, ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateResourceToProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateResourceToProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, associateResourceToProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateResourceToProfile");
            AssociateResourceToProfileResponse associateResourceToProfileResponse = (AssociateResourceToProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateResourceToProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateResourceToProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateResourceToProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateResourceToProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$associateResourceToProfile$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateProfileResponse createProfile(CreateProfileRequest createProfileRequest) throws LimitExceededException, InvalidParameterException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, createProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateProfile");
            CreateProfileResponse createProfileResponse = (CreateProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$createProfile$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteProfileResponse deleteProfile(DeleteProfileRequest deleteProfileRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, deleteProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteProfile");
            DeleteProfileResponse deleteProfileResponse = (DeleteProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$deleteProfile$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateProfileResponse disassociateProfile(DisassociateProfileRequest disassociateProfileRequest) throws ResourceNotFoundException, LimitExceededException, InvalidParameterException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, disassociateProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateProfile");
            DisassociateProfileResponse disassociateProfileResponse = (DisassociateProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$disassociateProfile$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateResourceFromProfileResponse disassociateResourceFromProfile(DisassociateResourceFromProfileRequest disassociateResourceFromProfileRequest) throws ResourceNotFoundException, LimitExceededException, InternalServiceErrorException, InvalidParameterException, ThrottlingException, ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateResourceFromProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateResourceFromProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, disassociateResourceFromProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateResourceFromProfile");
            DisassociateResourceFromProfileResponse disassociateResourceFromProfileResponse = (DisassociateResourceFromProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateResourceFromProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateResourceFromProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateResourceFromProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateResourceFromProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$disassociateResourceFromProfile$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetProfileResponse getProfile(GetProfileRequest getProfileRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, getProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetProfile");
            GetProfileResponse getProfileResponse = (GetProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$getProfile$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetProfileAssociationResponse getProfileAssociation(GetProfileAssociationRequest getProfileAssociationRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetProfileAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getProfileAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, getProfileAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetProfileAssociation");
            GetProfileAssociationResponse getProfileAssociationResponse = (GetProfileAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetProfileAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getProfileAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetProfileAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getProfileAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$getProfileAssociation$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetProfileResourceAssociationResponse getProfileResourceAssociation(GetProfileResourceAssociationRequest getProfileResourceAssociationRequest) throws ResourceNotFoundException, InvalidParameterException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetProfileResourceAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getProfileResourceAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, getProfileResourceAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetProfileResourceAssociation");
            GetProfileResourceAssociationResponse getProfileResourceAssociationResponse = (GetProfileResourceAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetProfileResourceAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getProfileResourceAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetProfileResourceAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getProfileResourceAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$getProfileResourceAssociation$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListProfileAssociationsResponse listProfileAssociations(ListProfileAssociationsRequest listProfileAssociationsRequest) throws InvalidParameterException, ThrottlingException, ValidationException, AccessDeniedException, InvalidNextTokenException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProfileAssociationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listProfileAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, listProfileAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListProfileAssociations");
            ListProfileAssociationsResponse listProfileAssociationsResponse = (ListProfileAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProfileAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listProfileAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListProfileAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listProfileAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$listProfileAssociations$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListProfileResourceAssociationsResponse listProfileResourceAssociations(ListProfileResourceAssociationsRequest listProfileResourceAssociationsRequest) throws ResourceNotFoundException, InternalServiceErrorException, InvalidParameterException, ThrottlingException, ValidationException, AccessDeniedException, InvalidNextTokenException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProfileResourceAssociationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listProfileResourceAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, listProfileResourceAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListProfileResourceAssociations");
            ListProfileResourceAssociationsResponse listProfileResourceAssociationsResponse = (ListProfileResourceAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProfileResourceAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listProfileResourceAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListProfileResourceAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listProfileResourceAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$listProfileResourceAssociations$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListProfilesResponse listProfiles(ListProfilesRequest listProfilesRequest) throws InvalidParameterException, ThrottlingException, ValidationException, AccessDeniedException, InvalidNextTokenException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProfilesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listProfilesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, listProfilesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListProfiles");
            ListProfilesResponse listProfilesResponse = (ListProfilesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProfiles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listProfilesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListProfilesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listProfilesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$listProfiles$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$listTagsForResource$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$tagResource$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$untagResource$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateProfileResourceAssociationResponse updateProfileResourceAssociation(UpdateProfileResourceAssociationRequest updateProfileResourceAssociationRequest) throws ResourceNotFoundException, LimitExceededException, InternalServiceErrorException, InvalidParameterException, ThrottlingException, ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, Route53ProfilesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateProfileResourceAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateProfileResourceAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53ProfilesClient.resolveMetricPublishers(clientConfiguration, updateProfileResourceAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53Profiles");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateProfileResourceAssociation");
            UpdateProfileResourceAssociationResponse updateProfileResourceAssociationResponse = (UpdateProfileResourceAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateProfileResourceAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateProfileResourceAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateProfileResourceAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateProfileResourceAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53ProfilesClient.lambda$updateProfileResourceAssociation$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "route53profiles";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        Route53ProfilesServiceClientConfigurationBuilder serviceConfigBuilder = new Route53ProfilesServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(Route53ProfilesException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").exceptionBuilderSupplier(InternalServiceErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceExistsException").exceptionBuilderSupplier(ResourceExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build());
    }

    @Override
    public final Route53ProfilesServiceClientConfiguration serviceClientConfiguration() {
        return new Route53ProfilesServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateProfileResourceAssociation$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listProfiles$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listProfileResourceAssociations$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listProfileAssociations$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getProfileResourceAssociation$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getProfileAssociation$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getProfile$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateResourceFromProfile$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateProfile$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteProfile$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createProfile$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateResourceToProfile$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateProfile$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

