/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53profiles.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProfileStatus {
    COMPLETE("COMPLETE"),
    DELETING("DELETING"),
    UPDATING("UPDATING"),
    CREATING("CREATING"),
    DELETED("DELETED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProfileStatus> VALUE_MAP;
    private final String value;

    private ProfileStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProfileStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProfileStatus> knownValues() {
        EnumSet<ProfileStatus> knownValues = EnumSet.allOf(ProfileStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProfileStatus.class, ProfileStatus::toString);
    }
}

