/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53profiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53profiles.model.ProfileAssociation;
import software.amazon.awssdk.services.route53profiles.model.ProfileAssociationsCopier;
import software.amazon.awssdk.services.route53profiles.model.Route53ProfilesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProfileAssociationsResponse
extends Route53ProfilesResponse
implements ToCopyableBuilder<Builder, ListProfileAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProfileAssociationsResponse.getter(ListProfileAssociationsResponse::nextToken)).setter(ListProfileAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ProfileAssociation>> PROFILE_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfileAssociations").getter(ListProfileAssociationsResponse.getter(ListProfileAssociationsResponse::profileAssociations)).setter(ListProfileAssociationsResponse.setter(Builder::profileAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfileAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PROFILE_ASSOCIATIONS_FIELD));
    private final String nextToken;
    private final List<ProfileAssociation> profileAssociations;

    private ListProfileAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.profileAssociations = builder.profileAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasProfileAssociations() {
        return this.profileAssociations != null && !(this.profileAssociations instanceof SdkAutoConstructList);
    }

    public final List<ProfileAssociation> profileAssociations() {
        return this.profileAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileAssociations() ? this.profileAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfileAssociationsResponse)) {
            return false;
        }
        ListProfileAssociationsResponse other = (ListProfileAssociationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasProfileAssociations() == other.hasProfileAssociations() && Objects.equals(this.profileAssociations(), other.profileAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"ListProfileAssociationsResponse").add("NextToken", (Object)this.nextToken()).add("ProfileAssociations", this.hasProfileAssociations() ? this.profileAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ProfileAssociations": {
                return Optional.ofNullable(clazz.cast(this.profileAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProfileAssociationsResponse, T> g) {
        return obj -> g.apply((ListProfileAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ProfilesResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ProfileAssociation> profileAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfileAssociationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.profileAssociations(model.profileAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ProfileAssociation.Builder> getProfileAssociations() {
            List<ProfileAssociation.Builder> result = ProfileAssociationsCopier.copyToBuilder(this.profileAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfileAssociations(Collection<ProfileAssociation.BuilderImpl> profileAssociations) {
            this.profileAssociations = ProfileAssociationsCopier.copyFromBuilder(profileAssociations);
        }

        @Override
        public final Builder profileAssociations(Collection<ProfileAssociation> profileAssociations) {
            this.profileAssociations = ProfileAssociationsCopier.copy(profileAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileAssociations(ProfileAssociation ... profileAssociations) {
            this.profileAssociations(Arrays.asList(profileAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileAssociations(Consumer<ProfileAssociation.Builder> ... profileAssociations) {
            this.profileAssociations(Stream.of(profileAssociations).map(c -> (ProfileAssociation)((ProfileAssociation.Builder)ProfileAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListProfileAssociationsResponse build() {
            return new ListProfileAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProfileAssociationsResponse> {
        public Builder nextToken(String var1);

        public Builder profileAssociations(Collection<ProfileAssociation> var1);

        public Builder profileAssociations(ProfileAssociation ... var1);

        public Builder profileAssociations(Consumer<ProfileAssociation.Builder> ... var1);
    }
}

