/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53globalresolver.Route53GlobalResolverAsyncClient;
import software.amazon.awssdk.services.route53globalresolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53globalresolver.model.AccessSourcesItem;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesResponse;

public class ListAccessSourcesPublisher
implements SdkPublisher<ListAccessSourcesResponse> {
    private final Route53GlobalResolverAsyncClient client;
    private final ListAccessSourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessSourcesPublisher(Route53GlobalResolverAsyncClient client, ListAccessSourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessSourcesPublisher(Route53GlobalResolverAsyncClient client, ListAccessSourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessSourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessSourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccessSourcesItem> accessSources() {
        Function<ListAccessSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessSources() != null) {
                return response.accessSources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccessSourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccessSourcesResponseFetcher
    implements AsyncPageFetcher<ListAccessSourcesResponse> {
        private ListAccessSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessSourcesResponse> nextPage(ListAccessSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListAccessSourcesPublisher.this.client.listAccessSources(ListAccessSourcesPublisher.this.firstRequest);
            }
            return ListAccessSourcesPublisher.this.client.listAccessSources((ListAccessSourcesRequest)((Object)ListAccessSourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

