/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53globalresolver.Route53GlobalResolverClient;
import software.amazon.awssdk.services.route53globalresolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsResponse;

public class ListFirewallDomainsIterable
implements SdkIterable<ListFirewallDomainsResponse> {
    private final Route53GlobalResolverClient client;
    private final ListFirewallDomainsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFirewallDomainsIterable(Route53GlobalResolverClient client, ListFirewallDomainsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFirewallDomainsResponseFetcher();
    }

    public Iterator<ListFirewallDomainsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> domains() {
        Function<ListFirewallDomainsResponse, Iterator> getIterator = response -> {
            if (response != null && response.domains() != null) {
                return response.domains().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFirewallDomainsResponseFetcher
    implements SyncPageFetcher<ListFirewallDomainsResponse> {
        private ListFirewallDomainsResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallDomainsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFirewallDomainsResponse nextPage(ListFirewallDomainsResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallDomainsIterable.this.client.listFirewallDomains(ListFirewallDomainsIterable.this.firstRequest);
            }
            return ListFirewallDomainsIterable.this.client.listFirewallDomains((ListFirewallDomainsRequest)((Object)ListFirewallDomainsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

