/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleInputItem;
import software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleInputItemsCopier;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateFirewallRuleRequest
extends Route53GlobalResolverRequest
implements ToCopyableBuilder<Builder, BatchUpdateFirewallRuleRequest> {
    private static final SdkField<List<BatchUpdateFirewallRuleInputItem>> FIREWALL_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("firewallRules").getter(BatchUpdateFirewallRuleRequest.getter(BatchUpdateFirewallRuleRequest::firewallRules)).setter(BatchUpdateFirewallRuleRequest.setter(Builder::firewallRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUpdateFirewallRuleInputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchUpdateFirewallRuleRequest.memberNameToFieldInitializer();
    private final List<BatchUpdateFirewallRuleInputItem> firewallRules;

    private BatchUpdateFirewallRuleRequest(BuilderImpl builder) {
        super(builder);
        this.firewallRules = builder.firewallRules;
    }

    public final boolean hasFirewallRules() {
        return this.firewallRules != null && !(this.firewallRules instanceof SdkAutoConstructList);
    }

    public final List<BatchUpdateFirewallRuleInputItem> firewallRules() {
        return this.firewallRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFirewallRules() ? this.firewallRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFirewallRuleRequest)) {
            return false;
        }
        BatchUpdateFirewallRuleRequest other = (BatchUpdateFirewallRuleRequest)((Object)obj);
        return this.hasFirewallRules() == other.hasFirewallRules() && Objects.equals(this.firewallRules(), other.firewallRules());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateFirewallRuleRequest").add("FirewallRules", this.hasFirewallRules() ? this.firewallRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "firewallRules": {
                return Optional.ofNullable(clazz.cast(this.firewallRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<BatchUpdateFirewallRuleInputItem>>> map = new HashMap<String, SdkField<List<BatchUpdateFirewallRuleInputItem>>>();
        map.put("firewallRules", FIREWALL_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateFirewallRuleRequest, T> g) {
        return obj -> g.apply((BatchUpdateFirewallRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverRequest.BuilderImpl
    implements Builder {
        private List<BatchUpdateFirewallRuleInputItem> firewallRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateFirewallRuleRequest model) {
            super(model);
            this.firewallRules(model.firewallRules);
        }

        public final List<BatchUpdateFirewallRuleInputItem.Builder> getFirewallRules() {
            List<BatchUpdateFirewallRuleInputItem.Builder> result = BatchUpdateFirewallRuleInputItemsCopier.copyToBuilder(this.firewallRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirewallRules(Collection<BatchUpdateFirewallRuleInputItem.BuilderImpl> firewallRules) {
            this.firewallRules = BatchUpdateFirewallRuleInputItemsCopier.copyFromBuilder(firewallRules);
        }

        @Override
        public final Builder firewallRules(Collection<BatchUpdateFirewallRuleInputItem> firewallRules) {
            this.firewallRules = BatchUpdateFirewallRuleInputItemsCopier.copy(firewallRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRules(BatchUpdateFirewallRuleInputItem ... firewallRules) {
            this.firewallRules(Arrays.asList(firewallRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRules(Consumer<BatchUpdateFirewallRuleInputItem.Builder> ... firewallRules) {
            this.firewallRules(Stream.of(firewallRules).map(c -> (BatchUpdateFirewallRuleInputItem)((BatchUpdateFirewallRuleInputItem.Builder)BatchUpdateFirewallRuleInputItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateFirewallRuleRequest build() {
            return new BatchUpdateFirewallRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateFirewallRuleRequest> {
        public Builder firewallRules(Collection<BatchUpdateFirewallRuleInputItem> var1);

        public Builder firewallRules(BatchUpdateFirewallRuleInputItem ... var1);

        public Builder firewallRules(Consumer<BatchUpdateFirewallRuleInputItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

