/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53globalresolver.Route53GlobalResolverAsyncClient;
import software.amazon.awssdk.services.route53globalresolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53globalresolver.model.DNSViewSummary;
import software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsResponse;

public class ListDNSViewsPublisher
implements SdkPublisher<ListDnsViewsResponse> {
    private final Route53GlobalResolverAsyncClient client;
    private final ListDnsViewsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDNSViewsPublisher(Route53GlobalResolverAsyncClient client, ListDnsViewsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDNSViewsPublisher(Route53GlobalResolverAsyncClient client, ListDnsViewsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDnsViewsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDnsViewsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DNSViewSummary> dnsViews() {
        Function<ListDnsViewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dnsViews() != null) {
                return response.dnsViews().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDnsViewsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDnsViewsResponseFetcher
    implements AsyncPageFetcher<ListDnsViewsResponse> {
        private ListDnsViewsResponseFetcher() {
        }

        public boolean hasNextPage(ListDnsViewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDnsViewsResponse> nextPage(ListDnsViewsResponse previousPage) {
            if (previousPage == null) {
                return ListDNSViewsPublisher.this.client.listDNSViews(ListDNSViewsPublisher.this.firstRequest);
            }
            return ListDNSViewsPublisher.this.client.listDNSViews((ListDnsViewsRequest)((Object)ListDNSViewsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

