/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DnsProtocol {
    DO53("DO53"),
    DOH("DOH"),
    DOT("DOT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DnsProtocol> VALUE_MAP;
    private final String value;

    private DnsProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DnsProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DnsProtocol> knownValues() {
        EnumSet<DnsProtocol> knownValues = EnumSet.allOf(DnsProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DnsProtocol.class, DnsProtocol::toString);
    }
}

