/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53globalresolver.Route53GlobalResolverClient;
import software.amazon.awssdk.services.route53globalresolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53globalresolver.model.HostedZoneAssociationSummary;
import software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsResponse;

public class ListHostedZoneAssociationsIterable
implements SdkIterable<ListHostedZoneAssociationsResponse> {
    private final Route53GlobalResolverClient client;
    private final ListHostedZoneAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHostedZoneAssociationsIterable(Route53GlobalResolverClient client, ListHostedZoneAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListHostedZoneAssociationsResponseFetcher();
    }

    public Iterator<ListHostedZoneAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HostedZoneAssociationSummary> hostedZoneAssociations() {
        Function<ListHostedZoneAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.hostedZoneAssociations() != null) {
                return response.hostedZoneAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListHostedZoneAssociationsResponseFetcher
    implements SyncPageFetcher<ListHostedZoneAssociationsResponse> {
        private ListHostedZoneAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListHostedZoneAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHostedZoneAssociationsResponse nextPage(ListHostedZoneAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListHostedZoneAssociationsIterable.this.client.listHostedZoneAssociations(ListHostedZoneAssociationsIterable.this.firstRequest);
            }
            return ListHostedZoneAssociationsIterable.this.client.listHostedZoneAssociations((ListHostedZoneAssociationsRequest)((Object)ListHostedZoneAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

