/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53globalresolver.Route53GlobalResolverClient;
import software.amazon.awssdk.services.route53globalresolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53globalresolver.model.GlobalResolversItem;
import software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversResponse;

public class ListGlobalResolversIterable
implements SdkIterable<ListGlobalResolversResponse> {
    private final Route53GlobalResolverClient client;
    private final ListGlobalResolversRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGlobalResolversIterable(Route53GlobalResolverClient client, ListGlobalResolversRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGlobalResolversResponseFetcher();
    }

    public Iterator<ListGlobalResolversResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GlobalResolversItem> globalResolvers() {
        Function<ListGlobalResolversResponse, Iterator> getIterator = response -> {
            if (response != null && response.globalResolvers() != null) {
                return response.globalResolvers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGlobalResolversResponseFetcher
    implements SyncPageFetcher<ListGlobalResolversResponse> {
        private ListGlobalResolversResponseFetcher() {
        }

        public boolean hasNextPage(ListGlobalResolversResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGlobalResolversResponse nextPage(ListGlobalResolversResponse previousPage) {
            if (previousPage == null) {
                return ListGlobalResolversIterable.this.client.listGlobalResolvers(ListGlobalResolversIterable.this.firstRequest);
            }
            return ListGlobalResolversIterable.this.client.listGlobalResolvers((ListGlobalResolversRequest)((Object)ListGlobalResolversIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

