/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53globalresolver.Route53GlobalResolverClient;
import software.amazon.awssdk.services.route53globalresolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53globalresolver.model.AccessSourcesItem;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesResponse;

public class ListAccessSourcesIterable
implements SdkIterable<ListAccessSourcesResponse> {
    private final Route53GlobalResolverClient client;
    private final ListAccessSourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessSourcesIterable(Route53GlobalResolverClient client, ListAccessSourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccessSourcesResponseFetcher();
    }

    public Iterator<ListAccessSourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccessSourcesItem> accessSources() {
        Function<ListAccessSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessSources() != null) {
                return response.accessSources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccessSourcesResponseFetcher
    implements SyncPageFetcher<ListAccessSourcesResponse> {
        private ListAccessSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessSourcesResponse nextPage(ListAccessSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListAccessSourcesIterable.this.client.listAccessSources(ListAccessSourcesIterable.this.firstRequest);
            }
            return ListAccessSourcesIterable.this.client.listAccessSources((ListAccessSourcesRequest)((Object)ListAccessSourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

