/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53globalresolver.model.DnsProtocol;
import software.amazon.awssdk.services.route53globalresolver.model.IpAddressType;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAccessSourceRequest
extends Route53GlobalResolverRequest
implements ToCopyableBuilder<Builder, UpdateAccessSourceRequest> {
    private static final SdkField<String> ACCESS_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessSourceId").getter(UpdateAccessSourceRequest.getter(UpdateAccessSourceRequest::accessSourceId)).setter(UpdateAccessSourceRequest.setter(Builder::accessSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accessSourceId").build()}).build();
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cidr").getter(UpdateAccessSourceRequest.getter(UpdateAccessSourceRequest::cidr)).setter(UpdateAccessSourceRequest.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidr").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddressType").getter(UpdateAccessSourceRequest.getter(UpdateAccessSourceRequest::ipAddressTypeAsString)).setter(UpdateAccessSourceRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateAccessSourceRequest.getter(UpdateAccessSourceRequest::name)).setter(UpdateAccessSourceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(UpdateAccessSourceRequest.getter(UpdateAccessSourceRequest::protocolAsString)).setter(UpdateAccessSourceRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_SOURCE_ID_FIELD, CIDR_FIELD, IP_ADDRESS_TYPE_FIELD, NAME_FIELD, PROTOCOL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAccessSourceRequest.memberNameToFieldInitializer();
    private final String accessSourceId;
    private final String cidr;
    private final String ipAddressType;
    private final String name;
    private final String protocol;

    private UpdateAccessSourceRequest(BuilderImpl builder) {
        super(builder);
        this.accessSourceId = builder.accessSourceId;
        this.cidr = builder.cidr;
        this.ipAddressType = builder.ipAddressType;
        this.name = builder.name;
        this.protocol = builder.protocol;
    }

    public final String accessSourceId() {
        return this.accessSourceId;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final String name() {
        return this.name;
    }

    public final DnsProtocol protocol() {
        return DnsProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccessSourceRequest)) {
            return false;
        }
        UpdateAccessSourceRequest other = (UpdateAccessSourceRequest)((Object)obj);
        return Objects.equals(this.accessSourceId(), other.accessSourceId()) && Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.protocolAsString(), other.protocolAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAccessSourceRequest").add("AccessSourceId", (Object)this.accessSourceId()).add("Cidr", (Object)this.cidr()).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("Name", (Object)this.name()).add("Protocol", (Object)this.protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessSourceId": {
                return Optional.ofNullable(clazz.cast(this.accessSourceId()));
            }
            case "cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "ipAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("accessSourceId", ACCESS_SOURCE_ID_FIELD);
        map.put("cidr", CIDR_FIELD);
        map.put("ipAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccessSourceRequest, T> g) {
        return obj -> g.apply((UpdateAccessSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverRequest.BuilderImpl
    implements Builder {
        private String accessSourceId;
        private String cidr;
        private String ipAddressType;
        private String name;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccessSourceRequest model) {
            super(model);
            this.accessSourceId(model.accessSourceId);
            this.cidr(model.cidr);
            this.ipAddressType(model.ipAddressType);
            this.name(model.name);
            this.protocol(model.protocol);
        }

        public final String getAccessSourceId() {
            return this.accessSourceId;
        }

        public final void setAccessSourceId(String accessSourceId) {
            this.accessSourceId = accessSourceId;
        }

        @Override
        public final Builder accessSourceId(String accessSourceId) {
            this.accessSourceId = accessSourceId;
            return this;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(DnsProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccessSourceRequest build() {
            return new UpdateAccessSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAccessSourceRequest> {
        public Builder accessSourceId(String var1);

        public Builder cidr(String var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder name(String var1);

        public Builder protocol(String var1);

        public Builder protocol(DnsProtocol var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

