/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53globalresolver.model.DnsSecValidationType;
import software.amazon.awssdk.services.route53globalresolver.model.EdnsClientSubnetType;
import software.amazon.awssdk.services.route53globalresolver.model.FirewallRulesFailOpenType;
import software.amazon.awssdk.services.route53globalresolver.model.ProfileResourceStatus;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDnsViewResponse
extends Route53GlobalResolverResponse
implements ToCopyableBuilder<Builder, GetDnsViewResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetDnsViewResponse.getter(GetDnsViewResponse::id)).setter(GetDnsViewResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetDnsViewResponse.getter(GetDnsViewResponse::arn)).setter(GetDnsViewResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(GetDnsViewResponse.getter(GetDnsViewResponse::clientToken)).setter(GetDnsViewResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> DNSSEC_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnssecValidation").getter(GetDnsViewResponse.getter(GetDnsViewResponse::dnssecValidationAsString)).setter(GetDnsViewResponse.setter(Builder::dnssecValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnssecValidation").build()}).build();
    private static final SdkField<String> EDNS_CLIENT_SUBNET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ednsClientSubnet").getter(GetDnsViewResponse.getter(GetDnsViewResponse::ednsClientSubnetAsString)).setter(GetDnsViewResponse.setter(Builder::ednsClientSubnet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ednsClientSubnet").build()}).build();
    private static final SdkField<String> FIREWALL_RULES_FAIL_OPEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("firewallRulesFailOpen").getter(GetDnsViewResponse.getter(GetDnsViewResponse::firewallRulesFailOpenAsString)).setter(GetDnsViewResponse.setter(Builder::firewallRulesFailOpen)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallRulesFailOpen").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetDnsViewResponse.getter(GetDnsViewResponse::name)).setter(GetDnsViewResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetDnsViewResponse.getter(GetDnsViewResponse::description)).setter(GetDnsViewResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> GLOBAL_RESOLVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("globalResolverId").getter(GetDnsViewResponse.getter(GetDnsViewResponse::globalResolverId)).setter(GetDnsViewResponse.setter(Builder::globalResolverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalResolverId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetDnsViewResponse.getter(GetDnsViewResponse::createdAt)).setter(GetDnsViewResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetDnsViewResponse.getter(GetDnsViewResponse::updatedAt)).setter(GetDnsViewResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetDnsViewResponse.getter(GetDnsViewResponse::statusAsString)).setter(GetDnsViewResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, CLIENT_TOKEN_FIELD, DNSSEC_VALIDATION_FIELD, EDNS_CLIENT_SUBNET_FIELD, FIREWALL_RULES_FAIL_OPEN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, GLOBAL_RESOLVER_ID_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDnsViewResponse.memberNameToFieldInitializer();
    private final String id;
    private final String arn;
    private final String clientToken;
    private final String dnssecValidation;
    private final String ednsClientSubnet;
    private final String firewallRulesFailOpen;
    private final String name;
    private final String description;
    private final String globalResolverId;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String status;

    private GetDnsViewResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.clientToken = builder.clientToken;
        this.dnssecValidation = builder.dnssecValidation;
        this.ednsClientSubnet = builder.ednsClientSubnet;
        this.firewallRulesFailOpen = builder.firewallRulesFailOpen;
        this.name = builder.name;
        this.description = builder.description;
        this.globalResolverId = builder.globalResolverId;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final DnsSecValidationType dnssecValidation() {
        return DnsSecValidationType.fromValue(this.dnssecValidation);
    }

    public final String dnssecValidationAsString() {
        return this.dnssecValidation;
    }

    public final EdnsClientSubnetType ednsClientSubnet() {
        return EdnsClientSubnetType.fromValue(this.ednsClientSubnet);
    }

    public final String ednsClientSubnetAsString() {
        return this.ednsClientSubnet;
    }

    public final FirewallRulesFailOpenType firewallRulesFailOpen() {
        return FirewallRulesFailOpenType.fromValue(this.firewallRulesFailOpen);
    }

    public final String firewallRulesFailOpenAsString() {
        return this.firewallRulesFailOpen;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String globalResolverId() {
        return this.globalResolverId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final ProfileResourceStatus status() {
        return ProfileResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnssecValidationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ednsClientSubnetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallRulesFailOpenAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalResolverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDnsViewResponse)) {
            return false;
        }
        GetDnsViewResponse other = (GetDnsViewResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dnssecValidationAsString(), other.dnssecValidationAsString()) && Objects.equals(this.ednsClientSubnetAsString(), other.ednsClientSubnetAsString()) && Objects.equals(this.firewallRulesFailOpenAsString(), other.firewallRulesFailOpenAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.globalResolverId(), other.globalResolverId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetDnsViewResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("ClientToken", (Object)this.clientToken()).add("DnssecValidation", (Object)this.dnssecValidationAsString()).add("EdnsClientSubnet", (Object)this.ednsClientSubnetAsString()).add("FirewallRulesFailOpen", (Object)this.firewallRulesFailOpenAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("GlobalResolverId", (Object)this.globalResolverId()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "dnssecValidation": {
                return Optional.ofNullable(clazz.cast(this.dnssecValidationAsString()));
            }
            case "ednsClientSubnet": {
                return Optional.ofNullable(clazz.cast(this.ednsClientSubnetAsString()));
            }
            case "firewallRulesFailOpen": {
                return Optional.ofNullable(clazz.cast(this.firewallRulesFailOpenAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "globalResolverId": {
                return Optional.ofNullable(clazz.cast(this.globalResolverId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("dnssecValidation", DNSSEC_VALIDATION_FIELD);
        map.put("ednsClientSubnet", EDNS_CLIENT_SUBNET_FIELD);
        map.put("firewallRulesFailOpen", FIREWALL_RULES_FAIL_OPEN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("globalResolverId", GLOBAL_RESOLVER_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDnsViewResponse, T> g) {
        return obj -> g.apply((GetDnsViewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String clientToken;
        private String dnssecValidation;
        private String ednsClientSubnet;
        private String firewallRulesFailOpen;
        private String name;
        private String description;
        private String globalResolverId;
        private Instant createdAt;
        private Instant updatedAt;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDnsViewResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.clientToken(model.clientToken);
            this.dnssecValidation(model.dnssecValidation);
            this.ednsClientSubnet(model.ednsClientSubnet);
            this.firewallRulesFailOpen(model.firewallRulesFailOpen);
            this.name(model.name);
            this.description(model.description);
            this.globalResolverId(model.globalResolverId);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.status(model.status);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDnssecValidation() {
            return this.dnssecValidation;
        }

        public final void setDnssecValidation(String dnssecValidation) {
            this.dnssecValidation = dnssecValidation;
        }

        @Override
        public final Builder dnssecValidation(String dnssecValidation) {
            this.dnssecValidation = dnssecValidation;
            return this;
        }

        @Override
        public final Builder dnssecValidation(DnsSecValidationType dnssecValidation) {
            this.dnssecValidation(dnssecValidation == null ? null : dnssecValidation.toString());
            return this;
        }

        public final String getEdnsClientSubnet() {
            return this.ednsClientSubnet;
        }

        public final void setEdnsClientSubnet(String ednsClientSubnet) {
            this.ednsClientSubnet = ednsClientSubnet;
        }

        @Override
        public final Builder ednsClientSubnet(String ednsClientSubnet) {
            this.ednsClientSubnet = ednsClientSubnet;
            return this;
        }

        @Override
        public final Builder ednsClientSubnet(EdnsClientSubnetType ednsClientSubnet) {
            this.ednsClientSubnet(ednsClientSubnet == null ? null : ednsClientSubnet.toString());
            return this;
        }

        public final String getFirewallRulesFailOpen() {
            return this.firewallRulesFailOpen;
        }

        public final void setFirewallRulesFailOpen(String firewallRulesFailOpen) {
            this.firewallRulesFailOpen = firewallRulesFailOpen;
        }

        @Override
        public final Builder firewallRulesFailOpen(String firewallRulesFailOpen) {
            this.firewallRulesFailOpen = firewallRulesFailOpen;
            return this;
        }

        @Override
        public final Builder firewallRulesFailOpen(FirewallRulesFailOpenType firewallRulesFailOpen) {
            this.firewallRulesFailOpen(firewallRulesFailOpen == null ? null : firewallRulesFailOpen.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getGlobalResolverId() {
            return this.globalResolverId;
        }

        public final void setGlobalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
        }

        @Override
        public final Builder globalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProfileResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetDnsViewResponse build() {
            return new GetDnsViewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDnsViewResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder clientToken(String var1);

        public Builder dnssecValidation(String var1);

        public Builder dnssecValidation(DnsSecValidationType var1);

        public Builder ednsClientSubnet(String var1);

        public Builder ednsClientSubnet(EdnsClientSubnetType var1);

        public Builder firewallRulesFailOpen(String var1);

        public Builder firewallRulesFailOpen(FirewallRulesFailOpenType var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder globalResolverId(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(ProfileResourceStatus var1);
    }
}

