/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGlobalResolverResponse extends Route53GlobalResolverResponse implements
        ToCopyableBuilder<UpdateGlobalResolverResponse.Builder, UpdateGlobalResolverResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateGlobalResolverResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateGlobalResolverResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(UpdateGlobalResolverResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dnsName").getter(getter(UpdateGlobalResolverResponse::dnsName)).setter(setter(Builder::dnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsName").build()).build();

    private static final SdkField<String> OBSERVABILITY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("observabilityRegion").getter(getter(UpdateGlobalResolverResponse::observabilityRegion))
            .setter(setter(Builder::observabilityRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("observabilityRegion").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateGlobalResolverResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateGlobalResolverResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("regions")
            .getter(getter(UpdateGlobalResolverResponse::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(UpdateGlobalResolverResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(UpdateGlobalResolverResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateGlobalResolverResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> IPV4_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ipv4Addresses")
            .getter(getter(UpdateGlobalResolverResponse::ipv4Addresses))
            .setter(setter(Builder::ipv4Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv4Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            CLIENT_TOKEN_FIELD, DNS_NAME_FIELD, OBSERVABILITY_REGION_FIELD, NAME_FIELD, DESCRIPTION_FIELD, REGIONS_FIELD,
            CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD, IPV4_ADDRESSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final String clientToken;

    private final String dnsName;

    private final String observabilityRegion;

    private final String name;

    private final String description;

    private final List<String> regions;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String status;

    private final List<String> ipv4Addresses;

    private UpdateGlobalResolverResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.clientToken = builder.clientToken;
        this.dnsName = builder.dnsName;
        this.observabilityRegion = builder.observabilityRegion;
        this.name = builder.name;
        this.description = builder.description;
        this.regions = builder.regions;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
        this.ipv4Addresses = builder.ipv4Addresses;
    }

    /**
     * <p>
     * The ID of the Global Resolver.
     * </p>
     * 
     * @return The ID of the Global Resolver.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Global Resolver.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Global Resolver.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency. This means that making the same request multiple times
     * with the same <code>clientToken</code> has the same result every time.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotency. This means that making the same request
     *         multiple times with the same <code>clientToken</code> has the same result every time.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The hostname to be used by the customers' DNS clients for certification validation.
     * </p>
     * 
     * @return The hostname to be used by the customers' DNS clients for certification validation.
     */
    public final String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * The AWS Regions in which the users' Global Resolver query resolution logs will be propagated.
     * </p>
     * 
     * @return The AWS Regions in which the users' Global Resolver query resolution logs will be propagated.
     */
    public final String observabilityRegion() {
        return observabilityRegion;
    }

    /**
     * <p>
     * Name of the Global Resolver.
     * </p>
     * 
     * @return Name of the Global Resolver.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Description of the Global Resolver.
     * </p>
     * 
     * @return Description of the Global Resolver.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS Regions in which the Global Resolver will operate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return The AWS Regions in which the Global Resolver will operate.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * <p>
     * The time and date the Global Resolverwas created.
     * </p>
     * 
     * @return The time and date the Global Resolverwas created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time and date the Global Resolver was updated.
     * </p>
     * 
     * @return The time and date the Global Resolver was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The operational status of the Global Resolver.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CRResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The operational status of the Global Resolver.
     * @see CRResourceStatus
     */
    public final CRResourceStatus status() {
        return CRResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The operational status of the Global Resolver.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CRResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The operational status of the Global Resolver.
     * @see CRResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv4Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv4Addresses() {
        return ipv4Addresses != null && !(ipv4Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of anycast IPv4 addresses associated with the Global Resolver instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv4Addresses} method.
     * </p>
     * 
     * @return List of anycast IPv4 addresses associated with the Global Resolver instance.
     */
    public final List<String> ipv4Addresses() {
        return ipv4Addresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(observabilityRegion());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv4Addresses() ? ipv4Addresses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalResolverResponse)) {
            return false;
        }
        UpdateGlobalResolverResponse other = (UpdateGlobalResolverResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(dnsName(), other.dnsName())
                && Objects.equals(observabilityRegion(), other.observabilityRegion()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasRegions() == other.hasRegions()
                && Objects.equals(regions(), other.regions()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasIpv4Addresses() == other.hasIpv4Addresses() && Objects.equals(ipv4Addresses(), other.ipv4Addresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGlobalResolverResponse").add("Id", id()).add("Arn", arn())
                .add("ClientToken", clientToken()).add("DnsName", dnsName()).add("ObservabilityRegion", observabilityRegion())
                .add("Name", name()).add("Description", description()).add("Regions", hasRegions() ? regions() : null)
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("Status", statusAsString())
                .add("Ipv4Addresses", hasIpv4Addresses() ? ipv4Addresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "dnsName":
            return Optional.ofNullable(clazz.cast(dnsName()));
        case "observabilityRegion":
            return Optional.ofNullable(clazz.cast(observabilityRegion()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ipv4Addresses":
            return Optional.ofNullable(clazz.cast(ipv4Addresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("dnsName", DNS_NAME_FIELD);
        map.put("observabilityRegion", OBSERVABILITY_REGION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("regions", REGIONS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("ipv4Addresses", IPV4_ADDRESSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGlobalResolverResponse, T> g) {
        return obj -> g.apply((UpdateGlobalResolverResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateGlobalResolverResponse> {
        /**
         * <p>
         * The ID of the Global Resolver.
         * </p>
         * 
         * @param id
         *        The ID of the Global Resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Global Resolver.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Global Resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotency. This means that making the same request multiple
         * times with the same <code>clientToken</code> has the same result every time.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotency. This means that making the same request
         *        multiple times with the same <code>clientToken</code> has the same result every time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The hostname to be used by the customers' DNS clients for certification validation.
         * </p>
         * 
         * @param dnsName
         *        The hostname to be used by the customers' DNS clients for certification validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * The AWS Regions in which the users' Global Resolver query resolution logs will be propagated.
         * </p>
         * 
         * @param observabilityRegion
         *        The AWS Regions in which the users' Global Resolver query resolution logs will be propagated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observabilityRegion(String observabilityRegion);

        /**
         * <p>
         * Name of the Global Resolver.
         * </p>
         * 
         * @param name
         *        Name of the Global Resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Description of the Global Resolver.
         * </p>
         * 
         * @param description
         *        Description of the Global Resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The AWS Regions in which the Global Resolver will operate.
         * </p>
         * 
         * @param regions
         *        The AWS Regions in which the Global Resolver will operate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * The AWS Regions in which the Global Resolver will operate.
         * </p>
         * 
         * @param regions
         *        The AWS Regions in which the Global Resolver will operate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * The time and date the Global Resolverwas created.
         * </p>
         * 
         * @param createdAt
         *        The time and date the Global Resolverwas created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time and date the Global Resolver was updated.
         * </p>
         * 
         * @param updatedAt
         *        The time and date the Global Resolver was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The operational status of the Global Resolver.
         * </p>
         * 
         * @param status
         *        The operational status of the Global Resolver.
         * @see CRResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CRResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The operational status of the Global Resolver.
         * </p>
         * 
         * @param status
         *        The operational status of the Global Resolver.
         * @see CRResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CRResourceStatus
         */
        Builder status(CRResourceStatus status);

        /**
         * <p>
         * List of anycast IPv4 addresses associated with the Global Resolver instance.
         * </p>
         * 
         * @param ipv4Addresses
         *        List of anycast IPv4 addresses associated with the Global Resolver instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Addresses(Collection<String> ipv4Addresses);

        /**
         * <p>
         * List of anycast IPv4 addresses associated with the Global Resolver instance.
         * </p>
         * 
         * @param ipv4Addresses
         *        List of anycast IPv4 addresses associated with the Global Resolver instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Addresses(String... ipv4Addresses);
    }

    static final class BuilderImpl extends Route53GlobalResolverResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String clientToken;

        private String dnsName;

        private String observabilityRegion;

        private String name;

        private String description;

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant updatedAt;

        private String status;

        private List<String> ipv4Addresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalResolverResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            clientToken(model.clientToken);
            dnsName(model.dnsName);
            observabilityRegion(model.observabilityRegion);
            name(model.name);
            description(model.description);
            regions(model.regions);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            status(model.status);
            ipv4Addresses(model.ipv4Addresses);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDnsName() {
            return dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getObservabilityRegion() {
            return observabilityRegion;
        }

        public final void setObservabilityRegion(String observabilityRegion) {
            this.observabilityRegion = observabilityRegion;
        }

        @Override
        public final Builder observabilityRegion(String observabilityRegion) {
            this.observabilityRegion = observabilityRegion;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CRResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getIpv4Addresses() {
            if (ipv4Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipv4Addresses;
        }

        public final void setIpv4Addresses(Collection<String> ipv4Addresses) {
            this.ipv4Addresses = IPv4AddressesCopier.copy(ipv4Addresses);
        }

        @Override
        public final Builder ipv4Addresses(Collection<String> ipv4Addresses) {
            this.ipv4Addresses = IPv4AddressesCopier.copy(ipv4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Addresses(String... ipv4Addresses) {
            ipv4Addresses(Arrays.asList(ipv4Addresses));
            return this;
        }

        @Override
        public UpdateGlobalResolverResponse build() {
            return new UpdateGlobalResolverResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
