/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessTokensResponse extends Route53GlobalResolverResponse implements
        ToCopyableBuilder<ListAccessTokensResponse.Builder, ListAccessTokensResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAccessTokensResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<AccessTokenItem>> ACCESS_TOKENS_FIELD = SdkField
            .<List<AccessTokenItem>> builder(MarshallingType.LIST)
            .memberName("accessTokens")
            .getter(getter(ListAccessTokensResponse::accessTokens))
            .setter(setter(Builder::accessTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessTokens").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessTokenItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessTokenItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ACCESS_TOKENS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<AccessTokenItem> accessTokens;

    private ListAccessTokensResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.accessTokens = builder.accessTokens;
    }

    /**
     * <p>
     * A pagination token used for large sets of results that can't be returned in a single response. Provide this token
     * in the next call to get the results not returned in this call.
     * </p>
     * 
     * @return A pagination token used for large sets of results that can't be returned in a single response. Provide
     *         this token in the next call to get the results not returned in this call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessTokens property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessTokens() {
        return accessTokens != null && !(accessTokens instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the tokens.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessTokens} method.
     * </p>
     * 
     * @return List of the tokens.
     */
    public final List<AccessTokenItem> accessTokens() {
        return accessTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessTokens() ? accessTokens() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessTokensResponse)) {
            return false;
        }
        ListAccessTokensResponse other = (ListAccessTokensResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasAccessTokens() == other.hasAccessTokens()
                && Objects.equals(accessTokens(), other.accessTokens());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessTokensResponse").add("NextToken", nextToken())
                .add("AccessTokens", hasAccessTokens() ? accessTokens() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "accessTokens":
            return Optional.ofNullable(clazz.cast(accessTokens()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("accessTokens", ACCESS_TOKENS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccessTokensResponse, T> g) {
        return obj -> g.apply((ListAccessTokensResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAccessTokensResponse> {
        /**
         * <p>
         * A pagination token used for large sets of results that can't be returned in a single response. Provide this
         * token in the next call to get the results not returned in this call.
         * </p>
         * 
         * @param nextToken
         *        A pagination token used for large sets of results that can't be returned in a single response. Provide
         *        this token in the next call to get the results not returned in this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of the tokens.
         * </p>
         * 
         * @param accessTokens
         *        List of the tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessTokens(Collection<AccessTokenItem> accessTokens);

        /**
         * <p>
         * List of the tokens.
         * </p>
         * 
         * @param accessTokens
         *        List of the tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessTokens(AccessTokenItem... accessTokens);

        /**
         * <p>
         * List of the tokens.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53globalresolver.model.AccessTokenItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.route53globalresolver.model.AccessTokenItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53globalresolver.model.AccessTokenItem.Builder#build()} is called
         * immediately and its result is passed to {@link #accessTokens(List<AccessTokenItem>)}.
         * 
         * @param accessTokens
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53globalresolver.model.AccessTokenItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessTokens(java.util.Collection<AccessTokenItem>)
         */
        Builder accessTokens(Consumer<AccessTokenItem.Builder>... accessTokens);
    }

    static final class BuilderImpl extends Route53GlobalResolverResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<AccessTokenItem> accessTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessTokensResponse model) {
            super(model);
            nextToken(model.nextToken);
            accessTokens(model.accessTokens);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AccessTokenItem.Builder> getAccessTokens() {
            List<AccessTokenItem.Builder> result = AccessTokensCopier.copyToBuilder(this.accessTokens);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessTokens(Collection<AccessTokenItem.BuilderImpl> accessTokens) {
            this.accessTokens = AccessTokensCopier.copyFromBuilder(accessTokens);
        }

        @Override
        public final Builder accessTokens(Collection<AccessTokenItem> accessTokens) {
            this.accessTokens = AccessTokensCopier.copy(accessTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTokens(AccessTokenItem... accessTokens) {
            accessTokens(Arrays.asList(accessTokens));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTokens(Consumer<AccessTokenItem.Builder>... accessTokens) {
            accessTokens(Stream.of(accessTokens).map(c -> AccessTokenItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAccessTokensResponse build() {
            return new ListAccessTokensResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
