/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccessTokenResponse extends Route53GlobalResolverResponse implements
        ToCopyableBuilder<GetAccessTokenResponse.Builder, GetAccessTokenResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetAccessTokenResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetAccessTokenResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(GetAccessTokenResponse::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetAccessTokenResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DNS_VIEW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dnsViewId").getter(getter(GetAccessTokenResponse::dnsViewId)).setter(setter(Builder::dnsViewId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsViewId").build()).build();

    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiresAt")
            .getter(getter(GetAccessTokenResponse::expiresAt))
            .setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> GLOBAL_RESOLVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("globalResolverId").getter(getter(GetAccessTokenResponse::globalResolverId))
            .setter(setter(Builder::globalResolverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalResolverId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetAccessTokenResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetAccessTokenResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetAccessTokenResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(GetAccessTokenResponse::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            CLIENT_TOKEN_FIELD, CREATED_AT_FIELD, DNS_VIEW_ID_FIELD, EXPIRES_AT_FIELD, GLOBAL_RESOLVER_ID_FIELD, NAME_FIELD,
            STATUS_FIELD, UPDATED_AT_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final String clientToken;

    private final Instant createdAt;

    private final String dnsViewId;

    private final Instant expiresAt;

    private final String globalResolverId;

    private final String name;

    private final String status;

    private final Instant updatedAt;

    private final String value;

    private GetAccessTokenResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.clientToken = builder.clientToken;
        this.createdAt = builder.createdAt;
        this.dnsViewId = builder.dnsViewId;
        this.expiresAt = builder.expiresAt;
        this.globalResolverId = builder.globalResolverId;
        this.name = builder.name;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
        this.value = builder.value;
    }

    /**
     * <p>
     * ID of the token.
     * </p>
     * 
     * @return ID of the token.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the token.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the token.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency. This means that making the same request multiple times
     * with the same <code>clientToken</code> has the same result every time.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotency. This means that making the same request
     *         multiple times with the same <code>clientToken</code> has the same result every time.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The time and date the token was created.
     * </p>
     * 
     * @return The time and date the token was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * ID of the DNS view the token is associated to.
     * </p>
     * 
     * @return ID of the DNS view the token is associated to.
     */
    public final String dnsViewId() {
        return dnsViewId;
    }

    /**
     * <p>
     * The token's expiration time and date.
     * </p>
     * 
     * @return The token's expiration time and date.
     */
    public final Instant expiresAt() {
        return expiresAt;
    }

    /**
     * <p>
     * ID of the Global Resolver.
     * </p>
     * 
     * @return ID of the Global Resolver.
     */
    public final String globalResolverId() {
        return globalResolverId;
    }

    /**
     * <p>
     * Name of the token.
     * </p>
     * 
     * @return Name of the token.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The operational status of the token.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TokenStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The operational status of the token.
     * @see TokenStatus
     */
    public final TokenStatus status() {
        return TokenStatus.fromValue(status);
    }

    /**
     * <p>
     * The operational status of the token.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TokenStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The operational status of the token.
     * @see TokenStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time and date the token was created.
     * </p>
     * 
     * @return The time and date the token was created.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The value of the token.
     * </p>
     * 
     * @return The value of the token.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(dnsViewId());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(globalResolverId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessTokenResponse)) {
            return false;
        }
        GetAccessTokenResponse other = (GetAccessTokenResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(dnsViewId(), other.dnsViewId()) && Objects.equals(expiresAt(), other.expiresAt())
                && Objects.equals(globalResolverId(), other.globalResolverId()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccessTokenResponse").add("Id", id()).add("Arn", arn()).add("ClientToken", clientToken())
                .add("CreatedAt", createdAt()).add("DnsViewId", dnsViewId()).add("ExpiresAt", expiresAt())
                .add("GlobalResolverId", globalResolverId()).add("Name", name()).add("Status", statusAsString())
                .add("UpdatedAt", updatedAt()).add("Value", value() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "dnsViewId":
            return Optional.ofNullable(clazz.cast(dnsViewId()));
        case "expiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        case "globalResolverId":
            return Optional.ofNullable(clazz.cast(globalResolverId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("dnsViewId", DNS_VIEW_ID_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        map.put("globalResolverId", GLOBAL_RESOLVER_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccessTokenResponse, T> g) {
        return obj -> g.apply((GetAccessTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAccessTokenResponse> {
        /**
         * <p>
         * ID of the token.
         * </p>
         * 
         * @param id
         *        ID of the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the token.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotency. This means that making the same request multiple
         * times with the same <code>clientToken</code> has the same result every time.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotency. This means that making the same request
         *        multiple times with the same <code>clientToken</code> has the same result every time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The time and date the token was created.
         * </p>
         * 
         * @param createdAt
         *        The time and date the token was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * ID of the DNS view the token is associated to.
         * </p>
         * 
         * @param dnsViewId
         *        ID of the DNS view the token is associated to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsViewId(String dnsViewId);

        /**
         * <p>
         * The token's expiration time and date.
         * </p>
         * 
         * @param expiresAt
         *        The token's expiration time and date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);

        /**
         * <p>
         * ID of the Global Resolver.
         * </p>
         * 
         * @param globalResolverId
         *        ID of the Global Resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalResolverId(String globalResolverId);

        /**
         * <p>
         * Name of the token.
         * </p>
         * 
         * @param name
         *        Name of the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The operational status of the token.
         * </p>
         * 
         * @param status
         *        The operational status of the token.
         * @see TokenStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TokenStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The operational status of the token.
         * </p>
         * 
         * @param status
         *        The operational status of the token.
         * @see TokenStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TokenStatus
         */
        Builder status(TokenStatus status);

        /**
         * <p>
         * The time and date the token was created.
         * </p>
         * 
         * @param updatedAt
         *        The time and date the token was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The value of the token.
         * </p>
         * 
         * @param value
         *        The value of the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl extends Route53GlobalResolverResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String clientToken;

        private Instant createdAt;

        private String dnsViewId;

        private Instant expiresAt;

        private String globalResolverId;

        private String name;

        private String status;

        private Instant updatedAt;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessTokenResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            clientToken(model.clientToken);
            createdAt(model.createdAt);
            dnsViewId(model.dnsViewId);
            expiresAt(model.expiresAt);
            globalResolverId(model.globalResolverId);
            name(model.name);
            status(model.status);
            updatedAt(model.updatedAt);
            value(model.value);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDnsViewId() {
            return dnsViewId;
        }

        public final void setDnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
        }

        @Override
        public final Builder dnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
            return this;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final String getGlobalResolverId() {
            return globalResolverId;
        }

        public final void setGlobalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
        }

        @Override
        public final Builder globalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TokenStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public GetAccessTokenResponse build() {
            return new GetAccessTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
