/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a firewall domain list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallDomainListsItem implements SdkPojo, Serializable,
        ToCopyableBuilder<FirewallDomainListsItem.Builder, FirewallDomainListsItem> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(FirewallDomainListsItem::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> GLOBAL_RESOLVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("globalResolverId").getter(getter(FirewallDomainListsItem::globalResolverId))
            .setter(setter(Builder::globalResolverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalResolverId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(FirewallDomainListsItem::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(FirewallDomainListsItem::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(FirewallDomainListsItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(FirewallDomainListsItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(FirewallDomainListsItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(FirewallDomainListsItem::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            GLOBAL_RESOLVER_ID_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String globalResolverId;

    private final Instant createdAt;

    private final String description;

    private final String id;

    private final String name;

    private final String status;

    private final Instant updatedAt;

    private FirewallDomainListsItem(BuilderImpl builder) {
        this.arn = builder.arn;
        this.globalResolverId = builder.globalResolverId;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall domain list.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall domain list.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the global resolver that the firewall domain list is associated with.
     * </p>
     * 
     * @return The ID of the global resolver that the firewall domain list is associated with.
     */
    public final String globalResolverId() {
        return globalResolverId;
    }

    /**
     * <p>
     * The date and time when the firewall domain list was created.
     * </p>
     * 
     * @return The date and time when the firewall domain list was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A description of the firewall domain list.
     * </p>
     * 
     * @return A description of the firewall domain list.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the firewall domain list.
     * </p>
     * 
     * @return The unique identifier of the firewall domain list.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the firewall domain list.
     * </p>
     * 
     * @return The name of the firewall domain list.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the firewall domain list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CRResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the firewall domain list.
     * @see CRResourceStatus
     */
    public final CRResourceStatus status() {
        return CRResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the firewall domain list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CRResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the firewall domain list.
     * @see CRResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time when the firewall domain list was last updated.
     * </p>
     * 
     * @return The date and time when the firewall domain list was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(globalResolverId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallDomainListsItem)) {
            return false;
        }
        FirewallDomainListsItem other = (FirewallDomainListsItem) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(globalResolverId(), other.globalResolverId())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallDomainListsItem").add("Arn", arn()).add("GlobalResolverId", globalResolverId())
                .add("CreatedAt", createdAt()).add("Description", description()).add("Id", id()).add("Name", name())
                .add("Status", statusAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "globalResolverId":
            return Optional.ofNullable(clazz.cast(globalResolverId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("globalResolverId", GLOBAL_RESOLVER_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FirewallDomainListsItem, T> g) {
        return obj -> g.apply((FirewallDomainListsItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallDomainListsItem> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall domain list.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the firewall domain list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the global resolver that the firewall domain list is associated with.
         * </p>
         * 
         * @param globalResolverId
         *        The ID of the global resolver that the firewall domain list is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalResolverId(String globalResolverId);

        /**
         * <p>
         * The date and time when the firewall domain list was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the firewall domain list was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A description of the firewall domain list.
         * </p>
         * 
         * @param description
         *        A description of the firewall domain list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the firewall domain list.
         * </p>
         * 
         * @param id
         *        The unique identifier of the firewall domain list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the firewall domain list.
         * </p>
         * 
         * @param name
         *        The name of the firewall domain list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the firewall domain list.
         * </p>
         * 
         * @param status
         *        The current status of the firewall domain list.
         * @see CRResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CRResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the firewall domain list.
         * </p>
         * 
         * @param status
         *        The current status of the firewall domain list.
         * @see CRResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CRResourceStatus
         */
        Builder status(CRResourceStatus status);

        /**
         * <p>
         * The date and time when the firewall domain list was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time when the firewall domain list was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String globalResolverId;

        private Instant createdAt;

        private String description;

        private String id;

        private String name;

        private String status;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallDomainListsItem model) {
            arn(model.arn);
            globalResolverId(model.globalResolverId);
            createdAt(model.createdAt);
            description(model.description);
            id(model.id);
            name(model.name);
            status(model.status);
            updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getGlobalResolverId() {
            return globalResolverId;
        }

        public final void setGlobalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
        }

        @Override
        public final Builder globalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CRResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public FirewallDomainListsItem build() {
            return new FirewallDomainListsItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
