/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGlobalResolverRequest extends Route53GlobalResolverRequest implements
        ToCopyableBuilder<CreateGlobalResolverRequest.Builder, CreateGlobalResolverRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateGlobalResolverRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateGlobalResolverRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateGlobalResolverRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OBSERVABILITY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("observabilityRegion").getter(getter(CreateGlobalResolverRequest::observabilityRegion))
            .setter(setter(Builder::observabilityRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("observabilityRegion").build())
            .build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("regions")
            .getter(getter(CreateGlobalResolverRequest::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateGlobalResolverRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, OBSERVABILITY_REGION_FIELD, REGIONS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String description;

    private final String name;

    private final String observabilityRegion;

    private final List<String> regions;

    private final Map<String, String> tags;

    private CreateGlobalResolverRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.name = builder.name;
        this.observabilityRegion = builder.observabilityRegion;
        this.regions = builder.regions;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique string that identifies the request and ensures idempotency. If you make multiple requests with the same
     * client token, only one Route 53 Global Resolver is created.
     * </p>
     * 
     * @return A unique string that identifies the request and ensures idempotency. If you make multiple requests with
     *         the same client token, only one Route 53 Global Resolver is created.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * An optional description for the Route 53 Global Resolver instance. Maximum length of 1024 characters.
     * </p>
     * 
     * @return An optional description for the Route 53 Global Resolver instance. Maximum length of 1024 characters.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A descriptive name for the Route 53 Global Resolver instance. Maximum length of 64 characters.
     * </p>
     * 
     * @return A descriptive name for the Route 53 Global Resolver instance. Maximum length of 64 characters.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The AWS region where query resolution logs and metrics will be aggregated and delivered. If not specified,
     * logging is not enabled.
     * </p>
     * 
     * @return The AWS region where query resolution logs and metrics will be aggregated and delivered. If not
     *         specified, logging is not enabled.
     */
    public final String observabilityRegion() {
        return observabilityRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of AWS regions where the Route 53 Global Resolver will operate. The resolver will be distributed across
     * these regions to provide global availability and low-latency DNS resolution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return List of AWS regions where the Route 53 Global Resolver will operate. The resolver will be distributed
     *         across these regions to provide global availability and low-latency DNS resolution.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags to associate with the Route 53 Global Resolver. Tags are key-value pairs that help you organize and identify
     * your resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to associate with the Route 53 Global Resolver. Tags are key-value pairs that help you organize and
     *         identify your resources.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(observabilityRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlobalResolverRequest)) {
            return false;
        }
        CreateGlobalResolverRequest other = (CreateGlobalResolverRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name()) && Objects.equals(observabilityRegion(), other.observabilityRegion())
                && hasRegions() == other.hasRegions() && Objects.equals(regions(), other.regions())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGlobalResolverRequest").add("ClientToken", clientToken())
                .add("Description", description()).add("Name", name()).add("ObservabilityRegion", observabilityRegion())
                .add("Regions", hasRegions() ? regions() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "observabilityRegion":
            return Optional.ofNullable(clazz.cast(observabilityRegion()));
        case "regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("observabilityRegion", OBSERVABILITY_REGION_FIELD);
        map.put("regions", REGIONS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGlobalResolverRequest, T> g) {
        return obj -> g.apply((CreateGlobalResolverRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateGlobalResolverRequest> {
        /**
         * <p>
         * A unique string that identifies the request and ensures idempotency. If you make multiple requests with the
         * same client token, only one Route 53 Global Resolver is created.
         * </p>
         * 
         * @param clientToken
         *        A unique string that identifies the request and ensures idempotency. If you make multiple requests
         *        with the same client token, only one Route 53 Global Resolver is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * An optional description for the Route 53 Global Resolver instance. Maximum length of 1024 characters.
         * </p>
         * 
         * @param description
         *        An optional description for the Route 53 Global Resolver instance. Maximum length of 1024 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A descriptive name for the Route 53 Global Resolver instance. Maximum length of 64 characters.
         * </p>
         * 
         * @param name
         *        A descriptive name for the Route 53 Global Resolver instance. Maximum length of 64 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The AWS region where query resolution logs and metrics will be aggregated and delivered. If not specified,
         * logging is not enabled.
         * </p>
         * 
         * @param observabilityRegion
         *        The AWS region where query resolution logs and metrics will be aggregated and delivered. If not
         *        specified, logging is not enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observabilityRegion(String observabilityRegion);

        /**
         * <p>
         * List of AWS regions where the Route 53 Global Resolver will operate. The resolver will be distributed across
         * these regions to provide global availability and low-latency DNS resolution.
         * </p>
         * 
         * @param regions
         *        List of AWS regions where the Route 53 Global Resolver will operate. The resolver will be distributed
         *        across these regions to provide global availability and low-latency DNS resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * List of AWS regions where the Route 53 Global Resolver will operate. The resolver will be distributed across
         * these regions to provide global availability and low-latency DNS resolution.
         * </p>
         * 
         * @param regions
         *        List of AWS regions where the Route 53 Global Resolver will operate. The resolver will be distributed
         *        across these regions to provide global availability and low-latency DNS resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * Tags to associate with the Route 53 Global Resolver. Tags are key-value pairs that help you organize and
         * identify your resources.
         * </p>
         * 
         * @param tags
         *        Tags to associate with the Route 53 Global Resolver. Tags are key-value pairs that help you organize
         *        and identify your resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53GlobalResolverRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private String name;

        private String observabilityRegion;

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlobalResolverRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            name(model.name);
            observabilityRegion(model.observabilityRegion);
            regions(model.regions);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getObservabilityRegion() {
            return observabilityRegion;
        }

        public final void setObservabilityRegion(String observabilityRegion) {
            this.observabilityRegion = observabilityRegion;
        }

        @Override
        public final Builder observabilityRegion(String observabilityRegion) {
            this.observabilityRegion = observabilityRegion;
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGlobalResolverRequest build() {
            return new CreateGlobalResolverRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
