/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information for updating a firewall rule in a batch operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateFirewallRuleInputItem implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchUpdateFirewallRuleInputItem.Builder, BatchUpdateFirewallRuleInputItem> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(BatchUpdateFirewallRuleInputItem::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> BLOCK_OVERRIDE_DNS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockOverrideDnsType").getter(getter(BatchUpdateFirewallRuleInputItem::blockOverrideDnsTypeAsString))
            .setter(setter(Builder::blockOverrideDnsType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockOverrideDnsType").build())
            .build();

    private static final SdkField<String> BLOCK_OVERRIDE_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockOverrideDomain").getter(getter(BatchUpdateFirewallRuleInputItem::blockOverrideDomain))
            .setter(setter(Builder::blockOverrideDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockOverrideDomain").build())
            .build();

    private static final SdkField<Integer> BLOCK_OVERRIDE_TTL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("blockOverrideTtl").getter(getter(BatchUpdateFirewallRuleInputItem::blockOverrideTtl))
            .setter(setter(Builder::blockOverrideTtl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockOverrideTtl").build()).build();

    private static final SdkField<String> BLOCK_RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockResponse").getter(getter(BatchUpdateFirewallRuleInputItem::blockResponseAsString))
            .setter(setter(Builder::blockResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockResponse").build()).build();

    private static final SdkField<String> CONFIDENCE_THRESHOLD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("confidenceThreshold").getter(getter(BatchUpdateFirewallRuleInputItem::confidenceThresholdAsString))
            .setter(setter(Builder::confidenceThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceThreshold").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(BatchUpdateFirewallRuleInputItem::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DNS_ADVANCED_PROTECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dnsAdvancedProtection").getter(getter(BatchUpdateFirewallRuleInputItem::dnsAdvancedProtectionAsString))
            .setter(setter(Builder::dnsAdvancedProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsAdvancedProtection").build())
            .build();

    private static final SdkField<String> FIREWALL_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firewallRuleId").getter(getter(BatchUpdateFirewallRuleInputItem::firewallRuleId))
            .setter(setter(Builder::firewallRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallRuleId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(BatchUpdateFirewallRuleInputItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Long> PRIORITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("priority")
            .getter(getter(BatchUpdateFirewallRuleInputItem::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            BLOCK_OVERRIDE_DNS_TYPE_FIELD, BLOCK_OVERRIDE_DOMAIN_FIELD, BLOCK_OVERRIDE_TTL_FIELD, BLOCK_RESPONSE_FIELD,
            CONFIDENCE_THRESHOLD_FIELD, DESCRIPTION_FIELD, DNS_ADVANCED_PROTECTION_FIELD, FIREWALL_RULE_ID_FIELD, NAME_FIELD,
            PRIORITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String blockOverrideDnsType;

    private final String blockOverrideDomain;

    private final Integer blockOverrideTtl;

    private final String blockResponse;

    private final String confidenceThreshold;

    private final String description;

    private final String dnsAdvancedProtection;

    private final String firewallRuleId;

    private final String name;

    private final Long priority;

    private BatchUpdateFirewallRuleInputItem(BuilderImpl builder) {
        this.action = builder.action;
        this.blockOverrideDnsType = builder.blockOverrideDnsType;
        this.blockOverrideDomain = builder.blockOverrideDomain;
        this.blockOverrideTtl = builder.blockOverrideTtl;
        this.blockResponse = builder.blockResponse;
        this.confidenceThreshold = builder.confidenceThreshold;
        this.description = builder.description;
        this.dnsAdvancedProtection = builder.dnsAdvancedProtection;
        this.firewallRuleId = builder.firewallRuleId;
        this.name = builder.name;
        this.priority = builder.priority;
    }

    /**
     * <p>
     * The action to take when a DNS query matches the firewall rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FirewallRuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to take when a DNS query matches the firewall rule.
     * @see FirewallRuleAction
     */
    public final FirewallRuleAction action() {
        return FirewallRuleAction.fromValue(action);
    }

    /**
     * <p>
     * The action to take when a DNS query matches the firewall rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FirewallRuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to take when a DNS query matches the firewall rule.
     * @see FirewallRuleAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The DNS record type for the custom response when the action is BLOCK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #blockOverrideDnsType} will return {@link BlockOverrideDnsQueryType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #blockOverrideDnsTypeAsString}.
     * </p>
     * 
     * @return The DNS record type for the custom response when the action is BLOCK.
     * @see BlockOverrideDnsQueryType
     */
    public final BlockOverrideDnsQueryType blockOverrideDnsType() {
        return BlockOverrideDnsQueryType.fromValue(blockOverrideDnsType);
    }

    /**
     * <p>
     * The DNS record type for the custom response when the action is BLOCK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #blockOverrideDnsType} will return {@link BlockOverrideDnsQueryType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #blockOverrideDnsTypeAsString}.
     * </p>
     * 
     * @return The DNS record type for the custom response when the action is BLOCK.
     * @see BlockOverrideDnsQueryType
     */
    public final String blockOverrideDnsTypeAsString() {
        return blockOverrideDnsType;
    }

    /**
     * <p>
     * The custom domain name for the BLOCK response.
     * </p>
     * 
     * @return The custom domain name for the BLOCK response.
     */
    public final String blockOverrideDomain() {
        return blockOverrideDomain;
    }

    /**
     * <p>
     * The TTL value for the custom response when the action is BLOCK.
     * </p>
     * 
     * @return The TTL value for the custom response when the action is BLOCK.
     */
    public final Integer blockOverrideTtl() {
        return blockOverrideTtl;
    }

    /**
     * <p>
     * The type of block response to return when the action is BLOCK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blockResponse}
     * will return {@link FirewallBlockResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #blockResponseAsString}.
     * </p>
     * 
     * @return The type of block response to return when the action is BLOCK.
     * @see FirewallBlockResponse
     */
    public final FirewallBlockResponse blockResponse() {
        return FirewallBlockResponse.fromValue(blockResponse);
    }

    /**
     * <p>
     * The type of block response to return when the action is BLOCK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blockResponse}
     * will return {@link FirewallBlockResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #blockResponseAsString}.
     * </p>
     * 
     * @return The type of block response to return when the action is BLOCK.
     * @see FirewallBlockResponse
     */
    public final String blockResponseAsString() {
        return blockResponse;
    }

    /**
     * <p>
     * The confidence threshold for advanced threat detection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #confidenceThreshold} will return {@link ConfidenceThreshold#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #confidenceThresholdAsString}.
     * </p>
     * 
     * @return The confidence threshold for advanced threat detection.
     * @see ConfidenceThreshold
     */
    public final ConfidenceThreshold confidenceThreshold() {
        return ConfidenceThreshold.fromValue(confidenceThreshold);
    }

    /**
     * <p>
     * The confidence threshold for advanced threat detection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #confidenceThreshold} will return {@link ConfidenceThreshold#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #confidenceThresholdAsString}.
     * </p>
     * 
     * @return The confidence threshold for advanced threat detection.
     * @see ConfidenceThreshold
     */
    public final String confidenceThresholdAsString() {
        return confidenceThreshold;
    }

    /**
     * <p>
     * A description of the firewall rule.
     * </p>
     * 
     * @return A description of the firewall rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether to enable advanced DNS threat protection for the firewall rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dnsAdvancedProtection} will return {@link DnsAdvancedProtection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dnsAdvancedProtectionAsString}.
     * </p>
     * 
     * @return Whether to enable advanced DNS threat protection for the firewall rule.
     * @see DnsAdvancedProtection
     */
    public final DnsAdvancedProtection dnsAdvancedProtection() {
        return DnsAdvancedProtection.fromValue(dnsAdvancedProtection);
    }

    /**
     * <p>
     * Whether to enable advanced DNS threat protection for the firewall rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dnsAdvancedProtection} will return {@link DnsAdvancedProtection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dnsAdvancedProtectionAsString}.
     * </p>
     * 
     * @return Whether to enable advanced DNS threat protection for the firewall rule.
     * @see DnsAdvancedProtection
     */
    public final String dnsAdvancedProtectionAsString() {
        return dnsAdvancedProtection;
    }

    /**
     * <p>
     * The unique identifier of the firewall rule to update.
     * </p>
     * 
     * @return The unique identifier of the firewall rule to update.
     */
    public final String firewallRuleId() {
        return firewallRuleId;
    }

    /**
     * <p>
     * A name for the firewall rule.
     * </p>
     * 
     * @return A name for the firewall rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The priority of the firewall rule.
     * </p>
     * 
     * @return The priority of the firewall rule.
     */
    public final Long priority() {
        return priority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blockOverrideDnsTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blockOverrideDomain());
        hashCode = 31 * hashCode + Objects.hashCode(blockOverrideTtl());
        hashCode = 31 * hashCode + Objects.hashCode(blockResponseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(confidenceThresholdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dnsAdvancedProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(firewallRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFirewallRuleInputItem)) {
            return false;
        }
        BatchUpdateFirewallRuleInputItem other = (BatchUpdateFirewallRuleInputItem) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(blockOverrideDnsTypeAsString(), other.blockOverrideDnsTypeAsString())
                && Objects.equals(blockOverrideDomain(), other.blockOverrideDomain())
                && Objects.equals(blockOverrideTtl(), other.blockOverrideTtl())
                && Objects.equals(blockResponseAsString(), other.blockResponseAsString())
                && Objects.equals(confidenceThresholdAsString(), other.confidenceThresholdAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(dnsAdvancedProtectionAsString(), other.dnsAdvancedProtectionAsString())
                && Objects.equals(firewallRuleId(), other.firewallRuleId()) && Objects.equals(name(), other.name())
                && Objects.equals(priority(), other.priority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateFirewallRuleInputItem").add("Action", actionAsString())
                .add("BlockOverrideDnsType", blockOverrideDnsTypeAsString()).add("BlockOverrideDomain", blockOverrideDomain())
                .add("BlockOverrideTtl", blockOverrideTtl()).add("BlockResponse", blockResponseAsString())
                .add("ConfidenceThreshold", confidenceThresholdAsString()).add("Description", description())
                .add("DnsAdvancedProtection", dnsAdvancedProtectionAsString()).add("FirewallRuleId", firewallRuleId())
                .add("Name", name()).add("Priority", priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "blockOverrideDnsType":
            return Optional.ofNullable(clazz.cast(blockOverrideDnsTypeAsString()));
        case "blockOverrideDomain":
            return Optional.ofNullable(clazz.cast(blockOverrideDomain()));
        case "blockOverrideTtl":
            return Optional.ofNullable(clazz.cast(blockOverrideTtl()));
        case "blockResponse":
            return Optional.ofNullable(clazz.cast(blockResponseAsString()));
        case "confidenceThreshold":
            return Optional.ofNullable(clazz.cast(confidenceThresholdAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "dnsAdvancedProtection":
            return Optional.ofNullable(clazz.cast(dnsAdvancedProtectionAsString()));
        case "firewallRuleId":
            return Optional.ofNullable(clazz.cast(firewallRuleId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("blockOverrideDnsType", BLOCK_OVERRIDE_DNS_TYPE_FIELD);
        map.put("blockOverrideDomain", BLOCK_OVERRIDE_DOMAIN_FIELD);
        map.put("blockOverrideTtl", BLOCK_OVERRIDE_TTL_FIELD);
        map.put("blockResponse", BLOCK_RESPONSE_FIELD);
        map.put("confidenceThreshold", CONFIDENCE_THRESHOLD_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("dnsAdvancedProtection", DNS_ADVANCED_PROTECTION_FIELD);
        map.put("firewallRuleId", FIREWALL_RULE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("priority", PRIORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateFirewallRuleInputItem, T> g) {
        return obj -> g.apply((BatchUpdateFirewallRuleInputItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchUpdateFirewallRuleInputItem> {
        /**
         * <p>
         * The action to take when a DNS query matches the firewall rule.
         * </p>
         * 
         * @param action
         *        The action to take when a DNS query matches the firewall rule.
         * @see FirewallRuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRuleAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to take when a DNS query matches the firewall rule.
         * </p>
         * 
         * @param action
         *        The action to take when a DNS query matches the firewall rule.
         * @see FirewallRuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRuleAction
         */
        Builder action(FirewallRuleAction action);

        /**
         * <p>
         * The DNS record type for the custom response when the action is BLOCK.
         * </p>
         * 
         * @param blockOverrideDnsType
         *        The DNS record type for the custom response when the action is BLOCK.
         * @see BlockOverrideDnsQueryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockOverrideDnsQueryType
         */
        Builder blockOverrideDnsType(String blockOverrideDnsType);

        /**
         * <p>
         * The DNS record type for the custom response when the action is BLOCK.
         * </p>
         * 
         * @param blockOverrideDnsType
         *        The DNS record type for the custom response when the action is BLOCK.
         * @see BlockOverrideDnsQueryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockOverrideDnsQueryType
         */
        Builder blockOverrideDnsType(BlockOverrideDnsQueryType blockOverrideDnsType);

        /**
         * <p>
         * The custom domain name for the BLOCK response.
         * </p>
         * 
         * @param blockOverrideDomain
         *        The custom domain name for the BLOCK response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockOverrideDomain(String blockOverrideDomain);

        /**
         * <p>
         * The TTL value for the custom response when the action is BLOCK.
         * </p>
         * 
         * @param blockOverrideTtl
         *        The TTL value for the custom response when the action is BLOCK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockOverrideTtl(Integer blockOverrideTtl);

        /**
         * <p>
         * The type of block response to return when the action is BLOCK.
         * </p>
         * 
         * @param blockResponse
         *        The type of block response to return when the action is BLOCK.
         * @see FirewallBlockResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallBlockResponse
         */
        Builder blockResponse(String blockResponse);

        /**
         * <p>
         * The type of block response to return when the action is BLOCK.
         * </p>
         * 
         * @param blockResponse
         *        The type of block response to return when the action is BLOCK.
         * @see FirewallBlockResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallBlockResponse
         */
        Builder blockResponse(FirewallBlockResponse blockResponse);

        /**
         * <p>
         * The confidence threshold for advanced threat detection.
         * </p>
         * 
         * @param confidenceThreshold
         *        The confidence threshold for advanced threat detection.
         * @see ConfidenceThreshold
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfidenceThreshold
         */
        Builder confidenceThreshold(String confidenceThreshold);

        /**
         * <p>
         * The confidence threshold for advanced threat detection.
         * </p>
         * 
         * @param confidenceThreshold
         *        The confidence threshold for advanced threat detection.
         * @see ConfidenceThreshold
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfidenceThreshold
         */
        Builder confidenceThreshold(ConfidenceThreshold confidenceThreshold);

        /**
         * <p>
         * A description of the firewall rule.
         * </p>
         * 
         * @param description
         *        A description of the firewall rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether to enable advanced DNS threat protection for the firewall rule.
         * </p>
         * 
         * @param dnsAdvancedProtection
         *        Whether to enable advanced DNS threat protection for the firewall rule.
         * @see DnsAdvancedProtection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsAdvancedProtection
         */
        Builder dnsAdvancedProtection(String dnsAdvancedProtection);

        /**
         * <p>
         * Whether to enable advanced DNS threat protection for the firewall rule.
         * </p>
         * 
         * @param dnsAdvancedProtection
         *        Whether to enable advanced DNS threat protection for the firewall rule.
         * @see DnsAdvancedProtection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsAdvancedProtection
         */
        Builder dnsAdvancedProtection(DnsAdvancedProtection dnsAdvancedProtection);

        /**
         * <p>
         * The unique identifier of the firewall rule to update.
         * </p>
         * 
         * @param firewallRuleId
         *        The unique identifier of the firewall rule to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRuleId(String firewallRuleId);

        /**
         * <p>
         * A name for the firewall rule.
         * </p>
         * 
         * @param name
         *        A name for the firewall rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The priority of the firewall rule.
         * </p>
         * 
         * @param priority
         *        The priority of the firewall rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Long priority);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String blockOverrideDnsType;

        private String blockOverrideDomain;

        private Integer blockOverrideTtl;

        private String blockResponse;

        private String confidenceThreshold;

        private String description;

        private String dnsAdvancedProtection;

        private String firewallRuleId;

        private String name;

        private Long priority;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateFirewallRuleInputItem model) {
            action(model.action);
            blockOverrideDnsType(model.blockOverrideDnsType);
            blockOverrideDomain(model.blockOverrideDomain);
            blockOverrideTtl(model.blockOverrideTtl);
            blockResponse(model.blockResponse);
            confidenceThreshold(model.confidenceThreshold);
            description(model.description);
            dnsAdvancedProtection(model.dnsAdvancedProtection);
            firewallRuleId(model.firewallRuleId);
            name(model.name);
            priority(model.priority);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(FirewallRuleAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getBlockOverrideDnsType() {
            return blockOverrideDnsType;
        }

        public final void setBlockOverrideDnsType(String blockOverrideDnsType) {
            this.blockOverrideDnsType = blockOverrideDnsType;
        }

        @Override
        public final Builder blockOverrideDnsType(String blockOverrideDnsType) {
            this.blockOverrideDnsType = blockOverrideDnsType;
            return this;
        }

        @Override
        public final Builder blockOverrideDnsType(BlockOverrideDnsQueryType blockOverrideDnsType) {
            this.blockOverrideDnsType(blockOverrideDnsType == null ? null : blockOverrideDnsType.toString());
            return this;
        }

        public final String getBlockOverrideDomain() {
            return blockOverrideDomain;
        }

        public final void setBlockOverrideDomain(String blockOverrideDomain) {
            this.blockOverrideDomain = blockOverrideDomain;
        }

        @Override
        public final Builder blockOverrideDomain(String blockOverrideDomain) {
            this.blockOverrideDomain = blockOverrideDomain;
            return this;
        }

        public final Integer getBlockOverrideTtl() {
            return blockOverrideTtl;
        }

        public final void setBlockOverrideTtl(Integer blockOverrideTtl) {
            this.blockOverrideTtl = blockOverrideTtl;
        }

        @Override
        public final Builder blockOverrideTtl(Integer blockOverrideTtl) {
            this.blockOverrideTtl = blockOverrideTtl;
            return this;
        }

        public final String getBlockResponse() {
            return blockResponse;
        }

        public final void setBlockResponse(String blockResponse) {
            this.blockResponse = blockResponse;
        }

        @Override
        public final Builder blockResponse(String blockResponse) {
            this.blockResponse = blockResponse;
            return this;
        }

        @Override
        public final Builder blockResponse(FirewallBlockResponse blockResponse) {
            this.blockResponse(blockResponse == null ? null : blockResponse.toString());
            return this;
        }

        public final String getConfidenceThreshold() {
            return confidenceThreshold;
        }

        public final void setConfidenceThreshold(String confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
        }

        @Override
        public final Builder confidenceThreshold(String confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
            return this;
        }

        @Override
        public final Builder confidenceThreshold(ConfidenceThreshold confidenceThreshold) {
            this.confidenceThreshold(confidenceThreshold == null ? null : confidenceThreshold.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDnsAdvancedProtection() {
            return dnsAdvancedProtection;
        }

        public final void setDnsAdvancedProtection(String dnsAdvancedProtection) {
            this.dnsAdvancedProtection = dnsAdvancedProtection;
        }

        @Override
        public final Builder dnsAdvancedProtection(String dnsAdvancedProtection) {
            this.dnsAdvancedProtection = dnsAdvancedProtection;
            return this;
        }

        @Override
        public final Builder dnsAdvancedProtection(DnsAdvancedProtection dnsAdvancedProtection) {
            this.dnsAdvancedProtection(dnsAdvancedProtection == null ? null : dnsAdvancedProtection.toString());
            return this;
        }

        public final String getFirewallRuleId() {
            return firewallRuleId;
        }

        public final void setFirewallRuleId(String firewallRuleId) {
            this.firewallRuleId = firewallRuleId;
        }

        @Override
        public final Builder firewallRuleId(String firewallRuleId) {
            this.firewallRuleId = firewallRuleId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getPriority() {
            return priority;
        }

        public final void setPriority(Long priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Long priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public BatchUpdateFirewallRuleInputItem build() {
            return new BatchUpdateFirewallRuleInputItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
