/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.HostedZoneLimit;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetHostedZoneLimitResponse
extends Route53Response
implements ToCopyableBuilder<Builder, GetHostedZoneLimitResponse> {
    private static final SdkField<HostedZoneLimit> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetHostedZoneLimitResponse.getter(GetHostedZoneLimitResponse::limit)).setter(GetHostedZoneLimitResponse.setter(Builder::limit)).constructor(HostedZoneLimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").unmarshallLocationName("Limit").build()}).build();
    private static final SdkField<Long> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(GetHostedZoneLimitResponse.getter(GetHostedZoneLimitResponse::count)).setter(GetHostedZoneLimitResponse.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").unmarshallLocationName("Count").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, COUNT_FIELD));
    private final HostedZoneLimit limit;
    private final Long count;

    private GetHostedZoneLimitResponse(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.count = builder.count;
    }

    public HostedZoneLimit limit() {
        return this.limit;
    }

    public Long count() {
        return this.count;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneLimitResponse)) {
            return false;
        }
        GetHostedZoneLimitResponse other = (GetHostedZoneLimitResponse)((Object)obj);
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.count(), other.count());
    }

    public String toString() {
        return ToString.builder((String)"GetHostedZoneLimitResponse").add("Limit", (Object)this.limit()).add("Count", (Object)this.count()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetHostedZoneLimitResponse, T> g) {
        return obj -> g.apply((GetHostedZoneLimitResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private HostedZoneLimit limit;
        private Long count;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostedZoneLimitResponse model) {
            super(model);
            this.limit(model.limit);
            this.count(model.count);
        }

        public final HostedZoneLimit.Builder getLimit() {
            return this.limit != null ? this.limit.toBuilder() : null;
        }

        @Override
        public final Builder limit(HostedZoneLimit limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(HostedZoneLimit.BuilderImpl limit) {
            this.limit = limit != null ? limit.build() : null;
        }

        public final Long getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public GetHostedZoneLimitResponse build() {
            return new GetHostedZoneLimitResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetHostedZoneLimitResponse> {
        public Builder limit(HostedZoneLimit var1);

        default public Builder limit(Consumer<HostedZoneLimit.Builder> limit) {
            return this.limit((HostedZoneLimit)((HostedZoneLimit.Builder)HostedZoneLimit.builder().applyMutation(limit)).build());
        }

        public Builder count(Long var1);
    }
}

