/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.AlarmIdentifier;
import software.amazon.awssdk.services.route53.model.ChildHealthCheckListCopier;
import software.amazon.awssdk.services.route53.model.HealthCheckRegion;
import software.amazon.awssdk.services.route53.model.HealthCheckRegionListCopier;
import software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus;
import software.amazon.awssdk.services.route53.model.ResettableElementName;
import software.amazon.awssdk.services.route53.model.ResettableElementNameListCopier;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateHealthCheckRequest
extends Route53Request
implements ToCopyableBuilder<Builder, UpdateHealthCheckRequest> {
    private static final SdkField<String> HEALTH_CHECK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthCheckId").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::healthCheckId)).setter(UpdateHealthCheckRequest.setter(Builder::healthCheckId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("HealthCheckId").unmarshallLocationName("HealthCheckId").build()}).build();
    private static final SdkField<Long> HEALTH_CHECK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("HealthCheckVersion").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::healthCheckVersion)).setter(UpdateHealthCheckRequest.setter(Builder::healthCheckVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckVersion").unmarshallLocationName("HealthCheckVersion").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IPAddress").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::ipAddress)).setter(UpdateHealthCheckRequest.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddress").unmarshallLocationName("IPAddress").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::port)).setter(UpdateHealthCheckRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").unmarshallLocationName("Port").build()}).build();
    private static final SdkField<String> RESOURCE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourcePath").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::resourcePath)).setter(UpdateHealthCheckRequest.setter(Builder::resourcePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePath").unmarshallLocationName("ResourcePath").build()}).build();
    private static final SdkField<String> FULLY_QUALIFIED_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FullyQualifiedDomainName").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::fullyQualifiedDomainName)).setter(UpdateHealthCheckRequest.setter(Builder::fullyQualifiedDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullyQualifiedDomainName").unmarshallLocationName("FullyQualifiedDomainName").build()}).build();
    private static final SdkField<String> SEARCH_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchString").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::searchString)).setter(UpdateHealthCheckRequest.setter(Builder::searchString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchString").unmarshallLocationName("SearchString").build()}).build();
    private static final SdkField<Integer> FAILURE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailureThreshold").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::failureThreshold)).setter(UpdateHealthCheckRequest.setter(Builder::failureThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureThreshold").unmarshallLocationName("FailureThreshold").build()}).build();
    private static final SdkField<Boolean> INVERTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Inverted").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::inverted)).setter(UpdateHealthCheckRequest.setter(Builder::inverted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inverted").unmarshallLocationName("Inverted").build()}).build();
    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Disabled").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::disabled)).setter(UpdateHealthCheckRequest.setter(Builder::disabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").unmarshallLocationName("Disabled").build()}).build();
    private static final SdkField<Integer> HEALTH_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HealthThreshold").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::healthThreshold)).setter(UpdateHealthCheckRequest.setter(Builder::healthThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthThreshold").unmarshallLocationName("HealthThreshold").build()}).build();
    private static final SdkField<List<String>> CHILD_HEALTH_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChildHealthChecks").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::childHealthChecks)).setter(UpdateHealthCheckRequest.setter(Builder::childHealthChecks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildHealthChecks").unmarshallLocationName("ChildHealthChecks").build(), ListTrait.builder().memberLocationName("ChildHealthCheck").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildHealthCheck").unmarshallLocationName("ChildHealthCheck").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_SNI_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableSNI").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::enableSNI)).setter(UpdateHealthCheckRequest.setter(Builder::enableSNI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableSNI").unmarshallLocationName("EnableSNI").build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Regions").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::regionsAsStrings)).setter(UpdateHealthCheckRequest.setter(Builder::regionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").unmarshallLocationName("Regions").build(), ListTrait.builder().memberLocationName("Region").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").unmarshallLocationName("Region").build()}).build()).build()}).build();
    private static final SdkField<AlarmIdentifier> ALARM_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlarmIdentifier").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::alarmIdentifier)).setter(UpdateHealthCheckRequest.setter(Builder::alarmIdentifier)).constructor(AlarmIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmIdentifier").unmarshallLocationName("AlarmIdentifier").build()}).build();
    private static final SdkField<String> INSUFFICIENT_DATA_HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InsufficientDataHealthStatus").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::insufficientDataHealthStatusAsString)).setter(UpdateHealthCheckRequest.setter(Builder::insufficientDataHealthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsufficientDataHealthStatus").unmarshallLocationName("InsufficientDataHealthStatus").build()}).build();
    private static final SdkField<List<String>> RESET_ELEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResetElements").getter(UpdateHealthCheckRequest.getter(UpdateHealthCheckRequest::resetElementsAsStrings)).setter(UpdateHealthCheckRequest.setter(Builder::resetElementsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResetElements").unmarshallLocationName("ResetElements").build(), ListTrait.builder().memberLocationName("ResettableElementName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResettableElementName").unmarshallLocationName("ResettableElementName").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_CHECK_ID_FIELD, HEALTH_CHECK_VERSION_FIELD, IP_ADDRESS_FIELD, PORT_FIELD, RESOURCE_PATH_FIELD, FULLY_QUALIFIED_DOMAIN_NAME_FIELD, SEARCH_STRING_FIELD, FAILURE_THRESHOLD_FIELD, INVERTED_FIELD, DISABLED_FIELD, HEALTH_THRESHOLD_FIELD, CHILD_HEALTH_CHECKS_FIELD, ENABLE_SNI_FIELD, REGIONS_FIELD, ALARM_IDENTIFIER_FIELD, INSUFFICIENT_DATA_HEALTH_STATUS_FIELD, RESET_ELEMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateHealthCheckRequest.memberNameToFieldInitializer();
    private final String healthCheckId;
    private final Long healthCheckVersion;
    private final String ipAddress;
    private final Integer port;
    private final String resourcePath;
    private final String fullyQualifiedDomainName;
    private final String searchString;
    private final Integer failureThreshold;
    private final Boolean inverted;
    private final Boolean disabled;
    private final Integer healthThreshold;
    private final List<String> childHealthChecks;
    private final Boolean enableSNI;
    private final List<String> regions;
    private final AlarmIdentifier alarmIdentifier;
    private final String insufficientDataHealthStatus;
    private final List<String> resetElements;

    private UpdateHealthCheckRequest(BuilderImpl builder) {
        super(builder);
        this.healthCheckId = builder.healthCheckId;
        this.healthCheckVersion = builder.healthCheckVersion;
        this.ipAddress = builder.ipAddress;
        this.port = builder.port;
        this.resourcePath = builder.resourcePath;
        this.fullyQualifiedDomainName = builder.fullyQualifiedDomainName;
        this.searchString = builder.searchString;
        this.failureThreshold = builder.failureThreshold;
        this.inverted = builder.inverted;
        this.disabled = builder.disabled;
        this.healthThreshold = builder.healthThreshold;
        this.childHealthChecks = builder.childHealthChecks;
        this.enableSNI = builder.enableSNI;
        this.regions = builder.regions;
        this.alarmIdentifier = builder.alarmIdentifier;
        this.insufficientDataHealthStatus = builder.insufficientDataHealthStatus;
        this.resetElements = builder.resetElements;
    }

    public final String healthCheckId() {
        return this.healthCheckId;
    }

    public final Long healthCheckVersion() {
        return this.healthCheckVersion;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final Integer port() {
        return this.port;
    }

    public final String resourcePath() {
        return this.resourcePath;
    }

    public final String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public final String searchString() {
        return this.searchString;
    }

    public final Integer failureThreshold() {
        return this.failureThreshold;
    }

    public final Boolean inverted() {
        return this.inverted;
    }

    public final Boolean disabled() {
        return this.disabled;
    }

    public final Integer healthThreshold() {
        return this.healthThreshold;
    }

    public final boolean hasChildHealthChecks() {
        return this.childHealthChecks != null && !(this.childHealthChecks instanceof SdkAutoConstructList);
    }

    public final List<String> childHealthChecks() {
        return this.childHealthChecks;
    }

    public final Boolean enableSNI() {
        return this.enableSNI;
    }

    public final List<HealthCheckRegion> regions() {
        return HealthCheckRegionListCopier.copyStringToEnum(this.regions);
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regionsAsStrings() {
        return this.regions;
    }

    public final AlarmIdentifier alarmIdentifier() {
        return this.alarmIdentifier;
    }

    public final InsufficientDataHealthStatus insufficientDataHealthStatus() {
        return InsufficientDataHealthStatus.fromValue(this.insufficientDataHealthStatus);
    }

    public final String insufficientDataHealthStatusAsString() {
        return this.insufficientDataHealthStatus;
    }

    public final List<ResettableElementName> resetElements() {
        return ResettableElementNameListCopier.copyStringToEnum(this.resetElements);
    }

    public final boolean hasResetElements() {
        return this.resetElements != null && !(this.resetElements instanceof SdkAutoConstructList);
    }

    public final List<String> resetElementsAsStrings() {
        return this.resetElements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckId());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullyQualifiedDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.inverted());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChildHealthChecks() ? this.childHealthChecks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableSNI());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.insufficientDataHealthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResetElements() ? this.resetElementsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHealthCheckRequest)) {
            return false;
        }
        UpdateHealthCheckRequest other = (UpdateHealthCheckRequest)((Object)obj);
        return Objects.equals(this.healthCheckId(), other.healthCheckId()) && Objects.equals(this.healthCheckVersion(), other.healthCheckVersion()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.resourcePath(), other.resourcePath()) && Objects.equals(this.fullyQualifiedDomainName(), other.fullyQualifiedDomainName()) && Objects.equals(this.searchString(), other.searchString()) && Objects.equals(this.failureThreshold(), other.failureThreshold()) && Objects.equals(this.inverted(), other.inverted()) && Objects.equals(this.disabled(), other.disabled()) && Objects.equals(this.healthThreshold(), other.healthThreshold()) && this.hasChildHealthChecks() == other.hasChildHealthChecks() && Objects.equals(this.childHealthChecks(), other.childHealthChecks()) && Objects.equals(this.enableSNI(), other.enableSNI()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regionsAsStrings(), other.regionsAsStrings()) && Objects.equals(this.alarmIdentifier(), other.alarmIdentifier()) && Objects.equals(this.insufficientDataHealthStatusAsString(), other.insufficientDataHealthStatusAsString()) && this.hasResetElements() == other.hasResetElements() && Objects.equals(this.resetElementsAsStrings(), other.resetElementsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateHealthCheckRequest").add("HealthCheckId", (Object)this.healthCheckId()).add("HealthCheckVersion", (Object)this.healthCheckVersion()).add("IPAddress", (Object)this.ipAddress()).add("Port", (Object)this.port()).add("ResourcePath", (Object)this.resourcePath()).add("FullyQualifiedDomainName", (Object)this.fullyQualifiedDomainName()).add("SearchString", (Object)this.searchString()).add("FailureThreshold", (Object)this.failureThreshold()).add("Inverted", (Object)this.inverted()).add("Disabled", (Object)this.disabled()).add("HealthThreshold", (Object)this.healthThreshold()).add("ChildHealthChecks", this.hasChildHealthChecks() ? this.childHealthChecks() : null).add("EnableSNI", (Object)this.enableSNI()).add("Regions", this.hasRegions() ? this.regionsAsStrings() : null).add("AlarmIdentifier", (Object)this.alarmIdentifier()).add("InsufficientDataHealthStatus", (Object)this.insufficientDataHealthStatusAsString()).add("ResetElements", this.hasResetElements() ? this.resetElementsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HealthCheckId": {
                return Optional.ofNullable(clazz.cast(this.healthCheckId()));
            }
            case "HealthCheckVersion": {
                return Optional.ofNullable(clazz.cast(this.healthCheckVersion()));
            }
            case "IPAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "ResourcePath": {
                return Optional.ofNullable(clazz.cast(this.resourcePath()));
            }
            case "FullyQualifiedDomainName": {
                return Optional.ofNullable(clazz.cast(this.fullyQualifiedDomainName()));
            }
            case "SearchString": {
                return Optional.ofNullable(clazz.cast(this.searchString()));
            }
            case "FailureThreshold": {
                return Optional.ofNullable(clazz.cast(this.failureThreshold()));
            }
            case "Inverted": {
                return Optional.ofNullable(clazz.cast(this.inverted()));
            }
            case "Disabled": {
                return Optional.ofNullable(clazz.cast(this.disabled()));
            }
            case "HealthThreshold": {
                return Optional.ofNullable(clazz.cast(this.healthThreshold()));
            }
            case "ChildHealthChecks": {
                return Optional.ofNullable(clazz.cast(this.childHealthChecks()));
            }
            case "EnableSNI": {
                return Optional.ofNullable(clazz.cast(this.enableSNI()));
            }
            case "Regions": {
                return Optional.ofNullable(clazz.cast(this.regionsAsStrings()));
            }
            case "AlarmIdentifier": {
                return Optional.ofNullable(clazz.cast(this.alarmIdentifier()));
            }
            case "InsufficientDataHealthStatus": {
                return Optional.ofNullable(clazz.cast(this.insufficientDataHealthStatusAsString()));
            }
            case "ResetElements": {
                return Optional.ofNullable(clazz.cast(this.resetElementsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HealthCheckId", HEALTH_CHECK_ID_FIELD);
        map.put("HealthCheckVersion", HEALTH_CHECK_VERSION_FIELD);
        map.put("IPAddress", IP_ADDRESS_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("ResourcePath", RESOURCE_PATH_FIELD);
        map.put("FullyQualifiedDomainName", FULLY_QUALIFIED_DOMAIN_NAME_FIELD);
        map.put("SearchString", SEARCH_STRING_FIELD);
        map.put("FailureThreshold", FAILURE_THRESHOLD_FIELD);
        map.put("Inverted", INVERTED_FIELD);
        map.put("Disabled", DISABLED_FIELD);
        map.put("HealthThreshold", HEALTH_THRESHOLD_FIELD);
        map.put("ChildHealthChecks", CHILD_HEALTH_CHECKS_FIELD);
        map.put("EnableSNI", ENABLE_SNI_FIELD);
        map.put("Regions", REGIONS_FIELD);
        map.put("AlarmIdentifier", ALARM_IDENTIFIER_FIELD);
        map.put("InsufficientDataHealthStatus", INSUFFICIENT_DATA_HEALTH_STATUS_FIELD);
        map.put("ResetElements", RESET_ELEMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateHealthCheckRequest, T> g) {
        return obj -> g.apply((UpdateHealthCheckRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String healthCheckId;
        private Long healthCheckVersion;
        private String ipAddress;
        private Integer port;
        private String resourcePath;
        private String fullyQualifiedDomainName;
        private String searchString;
        private Integer failureThreshold;
        private Boolean inverted;
        private Boolean disabled;
        private Integer healthThreshold;
        private List<String> childHealthChecks = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableSNI;
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private AlarmIdentifier alarmIdentifier;
        private String insufficientDataHealthStatus;
        private List<String> resetElements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHealthCheckRequest model) {
            super(model);
            this.healthCheckId(model.healthCheckId);
            this.healthCheckVersion(model.healthCheckVersion);
            this.ipAddress(model.ipAddress);
            this.port(model.port);
            this.resourcePath(model.resourcePath);
            this.fullyQualifiedDomainName(model.fullyQualifiedDomainName);
            this.searchString(model.searchString);
            this.failureThreshold(model.failureThreshold);
            this.inverted(model.inverted);
            this.disabled(model.disabled);
            this.healthThreshold(model.healthThreshold);
            this.childHealthChecks(model.childHealthChecks);
            this.enableSNI(model.enableSNI);
            this.regionsWithStrings(model.regions);
            this.alarmIdentifier(model.alarmIdentifier);
            this.insufficientDataHealthStatus(model.insufficientDataHealthStatus);
            this.resetElementsWithStrings(model.resetElements);
        }

        public final String getHealthCheckId() {
            return this.healthCheckId;
        }

        public final void setHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
        }

        @Override
        public final Builder healthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public final Long getHealthCheckVersion() {
            return this.healthCheckVersion;
        }

        public final void setHealthCheckVersion(Long healthCheckVersion) {
            this.healthCheckVersion = healthCheckVersion;
        }

        @Override
        public final Builder healthCheckVersion(Long healthCheckVersion) {
            this.healthCheckVersion = healthCheckVersion;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getResourcePath() {
            return this.resourcePath;
        }

        public final void setResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        @Override
        public final Builder resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        public final String getFullyQualifiedDomainName() {
            return this.fullyQualifiedDomainName;
        }

        public final void setFullyQualifiedDomainName(String fullyQualifiedDomainName) {
            this.fullyQualifiedDomainName = fullyQualifiedDomainName;
        }

        @Override
        public final Builder fullyQualifiedDomainName(String fullyQualifiedDomainName) {
            this.fullyQualifiedDomainName = fullyQualifiedDomainName;
            return this;
        }

        public final String getSearchString() {
            return this.searchString;
        }

        public final void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        @Override
        public final Builder searchString(String searchString) {
            this.searchString = searchString;
            return this;
        }

        public final Integer getFailureThreshold() {
            return this.failureThreshold;
        }

        public final void setFailureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
        }

        @Override
        public final Builder failureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        public final Boolean getInverted() {
            return this.inverted;
        }

        public final void setInverted(Boolean inverted) {
            this.inverted = inverted;
        }

        @Override
        public final Builder inverted(Boolean inverted) {
            this.inverted = inverted;
            return this;
        }

        public final Boolean getDisabled() {
            return this.disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final Integer getHealthThreshold() {
            return this.healthThreshold;
        }

        public final void setHealthThreshold(Integer healthThreshold) {
            this.healthThreshold = healthThreshold;
        }

        @Override
        public final Builder healthThreshold(Integer healthThreshold) {
            this.healthThreshold = healthThreshold;
            return this;
        }

        public final Collection<String> getChildHealthChecks() {
            if (this.childHealthChecks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.childHealthChecks;
        }

        public final void setChildHealthChecks(Collection<String> childHealthChecks) {
            this.childHealthChecks = ChildHealthCheckListCopier.copy(childHealthChecks);
        }

        @Override
        public final Builder childHealthChecks(Collection<String> childHealthChecks) {
            this.childHealthChecks = ChildHealthCheckListCopier.copy(childHealthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childHealthChecks(String ... childHealthChecks) {
            this.childHealthChecks(Arrays.asList(childHealthChecks));
            return this;
        }

        public final Boolean getEnableSNI() {
            return this.enableSNI;
        }

        public final void setEnableSNI(Boolean enableSNI) {
            this.enableSNI = enableSNI;
        }

        @Override
        public final Builder enableSNI(Boolean enableSNI) {
            this.enableSNI = enableSNI;
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = HealthCheckRegionListCopier.copy(regions);
        }

        @Override
        public final Builder regionsWithStrings(Collection<String> regions) {
            this.regions = HealthCheckRegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsWithStrings(String ... regions) {
            this.regionsWithStrings(Arrays.asList(regions));
            return this;
        }

        @Override
        public final Builder regions(Collection<HealthCheckRegion> regions) {
            this.regions = HealthCheckRegionListCopier.copyEnumToString(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(HealthCheckRegion ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final AlarmIdentifier.Builder getAlarmIdentifier() {
            return this.alarmIdentifier != null ? this.alarmIdentifier.toBuilder() : null;
        }

        public final void setAlarmIdentifier(AlarmIdentifier.BuilderImpl alarmIdentifier) {
            this.alarmIdentifier = alarmIdentifier != null ? alarmIdentifier.build() : null;
        }

        @Override
        public final Builder alarmIdentifier(AlarmIdentifier alarmIdentifier) {
            this.alarmIdentifier = alarmIdentifier;
            return this;
        }

        public final String getInsufficientDataHealthStatus() {
            return this.insufficientDataHealthStatus;
        }

        public final void setInsufficientDataHealthStatus(String insufficientDataHealthStatus) {
            this.insufficientDataHealthStatus = insufficientDataHealthStatus;
        }

        @Override
        public final Builder insufficientDataHealthStatus(String insufficientDataHealthStatus) {
            this.insufficientDataHealthStatus = insufficientDataHealthStatus;
            return this;
        }

        @Override
        public final Builder insufficientDataHealthStatus(InsufficientDataHealthStatus insufficientDataHealthStatus) {
            this.insufficientDataHealthStatus(insufficientDataHealthStatus == null ? null : insufficientDataHealthStatus.toString());
            return this;
        }

        public final Collection<String> getResetElements() {
            if (this.resetElements instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resetElements;
        }

        public final void setResetElements(Collection<String> resetElements) {
            this.resetElements = ResettableElementNameListCopier.copy(resetElements);
        }

        @Override
        public final Builder resetElementsWithStrings(Collection<String> resetElements) {
            this.resetElements = ResettableElementNameListCopier.copy(resetElements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resetElementsWithStrings(String ... resetElements) {
            this.resetElementsWithStrings(Arrays.asList(resetElements));
            return this;
        }

        @Override
        public final Builder resetElements(Collection<ResettableElementName> resetElements) {
            this.resetElements = ResettableElementNameListCopier.copyEnumToString(resetElements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resetElements(ResettableElementName ... resetElements) {
            this.resetElements(Arrays.asList(resetElements));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHealthCheckRequest build() {
            return new UpdateHealthCheckRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateHealthCheckRequest> {
        public Builder healthCheckId(String var1);

        public Builder healthCheckVersion(Long var1);

        public Builder ipAddress(String var1);

        public Builder port(Integer var1);

        public Builder resourcePath(String var1);

        public Builder fullyQualifiedDomainName(String var1);

        public Builder searchString(String var1);

        public Builder failureThreshold(Integer var1);

        public Builder inverted(Boolean var1);

        public Builder disabled(Boolean var1);

        public Builder healthThreshold(Integer var1);

        public Builder childHealthChecks(Collection<String> var1);

        public Builder childHealthChecks(String ... var1);

        public Builder enableSNI(Boolean var1);

        public Builder regionsWithStrings(Collection<String> var1);

        public Builder regionsWithStrings(String ... var1);

        public Builder regions(Collection<HealthCheckRegion> var1);

        public Builder regions(HealthCheckRegion ... var1);

        public Builder alarmIdentifier(AlarmIdentifier var1);

        default public Builder alarmIdentifier(Consumer<AlarmIdentifier.Builder> alarmIdentifier) {
            return this.alarmIdentifier((AlarmIdentifier)((AlarmIdentifier.Builder)AlarmIdentifier.builder().applyMutation(alarmIdentifier)).build());
        }

        public Builder insufficientDataHealthStatus(String var1);

        public Builder insufficientDataHealthStatus(InsufficientDataHealthStatus var1);

        public Builder resetElementsWithStrings(Collection<String> var1);

        public Builder resetElementsWithStrings(String ... var1);

        public Builder resetElements(Collection<ResettableElementName> var1);

        public Builder resetElements(ResettableElementName ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

