/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.route53.model.GetChangeRequest;
import software.amazon.awssdk.services.route53.model.GetChangeResponse;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.services.route53.waiters.Route53Waiter;
import software.amazon.awssdk.services.route53.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultRoute53Waiter
implements Route53Waiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final Route53Client client;
    private final AttributeMap managedResources;
    private final Waiter<GetChangeResponse> resourceRecordSetsChangedWaiter;

    private DefaultRoute53Waiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (Route53Client)Route53Client.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.resourceRecordSetsChangedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetChangeResponse.class).acceptors(DefaultRoute53Waiter.resourceRecordSetsChangedWaiterAcceptors())).overrideConfiguration(DefaultRoute53Waiter.resourceRecordSetsChangedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetChangeResponse> waitUntilResourceRecordSetsChanged(GetChangeRequest getChangeRequest) {
        return this.resourceRecordSetsChangedWaiter.run(() -> this.client.getChange(this.applyWaitersUserAgent(getChangeRequest)));
    }

    @Override
    public WaiterResponse<GetChangeResponse> waitUntilResourceRecordSetsChanged(GetChangeRequest getChangeRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.resourceRecordSetsChangedWaiter.run(() -> this.client.getChange(this.applyWaitersUserAgent(getChangeRequest)), DefaultRoute53Waiter.resourceRecordSetsChangedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetChangeResponse>> resourceRecordSetsChangedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetChangeResponse>> result = new ArrayList<WaiterAcceptor<? super GetChangeResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ChangeInfo").field("Status").value(), "INSYNC");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration resourceRecordSetsChangedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static Route53Waiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends Route53Request> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((Route53Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements Route53Waiter.Builder {
        private Route53Client client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public Route53Waiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public Route53Waiter.Builder client(Route53Client client) {
            this.client = client;
            return this;
        }

        @Override
        public Route53Waiter build() {
            return new DefaultRoute53Waiter(this);
        }
    }
}

