/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.GeoLocationDetails;
import software.amazon.awssdk.services.route53.model.GeoLocationDetailsListCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGeoLocationsResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListGeoLocationsResponse> {
    private static final SdkField<List<GeoLocationDetails>> GEO_LOCATION_DETAILS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GeoLocationDetailsList").getter(ListGeoLocationsResponse.getter(ListGeoLocationsResponse::geoLocationDetailsList)).setter(ListGeoLocationsResponse.setter(Builder::geoLocationDetailsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoLocationDetailsList").unmarshallLocationName("GeoLocationDetailsList").build(), ListTrait.builder().memberLocationName("GeoLocationDetails").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GeoLocationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoLocationDetails").unmarshallLocationName("GeoLocationDetails").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(ListGeoLocationsResponse.getter(ListGeoLocationsResponse::isTruncated)).setter(ListGeoLocationsResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").unmarshallLocationName("IsTruncated").build()}).build();
    private static final SdkField<String> NEXT_CONTINENT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextContinentCode").getter(ListGeoLocationsResponse.getter(ListGeoLocationsResponse::nextContinentCode)).setter(ListGeoLocationsResponse.setter(Builder::nextContinentCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextContinentCode").unmarshallLocationName("NextContinentCode").build()}).build();
    private static final SdkField<String> NEXT_COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextCountryCode").getter(ListGeoLocationsResponse.getter(ListGeoLocationsResponse::nextCountryCode)).setter(ListGeoLocationsResponse.setter(Builder::nextCountryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextCountryCode").unmarshallLocationName("NextCountryCode").build()}).build();
    private static final SdkField<String> NEXT_SUBDIVISION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextSubdivisionCode").getter(ListGeoLocationsResponse.getter(ListGeoLocationsResponse::nextSubdivisionCode)).setter(ListGeoLocationsResponse.setter(Builder::nextSubdivisionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextSubdivisionCode").unmarshallLocationName("NextSubdivisionCode").build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxItems").getter(ListGeoLocationsResponse.getter(ListGeoLocationsResponse::maxItems)).setter(ListGeoLocationsResponse.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GEO_LOCATION_DETAILS_LIST_FIELD, IS_TRUNCATED_FIELD, NEXT_CONTINENT_CODE_FIELD, NEXT_COUNTRY_CODE_FIELD, NEXT_SUBDIVISION_CODE_FIELD, MAX_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListGeoLocationsResponse.memberNameToFieldInitializer();
    private final List<GeoLocationDetails> geoLocationDetailsList;
    private final Boolean isTruncated;
    private final String nextContinentCode;
    private final String nextCountryCode;
    private final String nextSubdivisionCode;
    private final String maxItems;

    private ListGeoLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.geoLocationDetailsList = builder.geoLocationDetailsList;
        this.isTruncated = builder.isTruncated;
        this.nextContinentCode = builder.nextContinentCode;
        this.nextCountryCode = builder.nextCountryCode;
        this.nextSubdivisionCode = builder.nextSubdivisionCode;
        this.maxItems = builder.maxItems;
    }

    public final boolean hasGeoLocationDetailsList() {
        return this.geoLocationDetailsList != null && !(this.geoLocationDetailsList instanceof SdkAutoConstructList);
    }

    public final List<GeoLocationDetails> geoLocationDetailsList() {
        return this.geoLocationDetailsList;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final String nextContinentCode() {
        return this.nextContinentCode;
    }

    public final String nextCountryCode() {
        return this.nextCountryCode;
    }

    public final String nextSubdivisionCode() {
        return this.nextSubdivisionCode;
    }

    public final String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeoLocationDetailsList() ? this.geoLocationDetailsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextContinentCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextSubdivisionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeoLocationsResponse)) {
            return false;
        }
        ListGeoLocationsResponse other = (ListGeoLocationsResponse)((Object)obj);
        return this.hasGeoLocationDetailsList() == other.hasGeoLocationDetailsList() && Objects.equals(this.geoLocationDetailsList(), other.geoLocationDetailsList()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.nextContinentCode(), other.nextContinentCode()) && Objects.equals(this.nextCountryCode(), other.nextCountryCode()) && Objects.equals(this.nextSubdivisionCode(), other.nextSubdivisionCode()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListGeoLocationsResponse").add("GeoLocationDetailsList", this.hasGeoLocationDetailsList() ? this.geoLocationDetailsList() : null).add("IsTruncated", (Object)this.isTruncated()).add("NextContinentCode", (Object)this.nextContinentCode()).add("NextCountryCode", (Object)this.nextCountryCode()).add("NextSubdivisionCode", (Object)this.nextSubdivisionCode()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GeoLocationDetailsList": {
                return Optional.ofNullable(clazz.cast(this.geoLocationDetailsList()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "NextContinentCode": {
                return Optional.ofNullable(clazz.cast(this.nextContinentCode()));
            }
            case "NextCountryCode": {
                return Optional.ofNullable(clazz.cast(this.nextCountryCode()));
            }
            case "NextSubdivisionCode": {
                return Optional.ofNullable(clazz.cast(this.nextSubdivisionCode()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GeoLocationDetailsList", GEO_LOCATION_DETAILS_LIST_FIELD);
        map.put("IsTruncated", IS_TRUNCATED_FIELD);
        map.put("NextContinentCode", NEXT_CONTINENT_CODE_FIELD);
        map.put("NextCountryCode", NEXT_COUNTRY_CODE_FIELD);
        map.put("NextSubdivisionCode", NEXT_SUBDIVISION_CODE_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGeoLocationsResponse, T> g) {
        return obj -> g.apply((ListGeoLocationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<GeoLocationDetails> geoLocationDetailsList = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String nextContinentCode;
        private String nextCountryCode;
        private String nextSubdivisionCode;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeoLocationsResponse model) {
            super(model);
            this.geoLocationDetailsList(model.geoLocationDetailsList);
            this.isTruncated(model.isTruncated);
            this.nextContinentCode(model.nextContinentCode);
            this.nextCountryCode(model.nextCountryCode);
            this.nextSubdivisionCode(model.nextSubdivisionCode);
            this.maxItems(model.maxItems);
        }

        public final List<GeoLocationDetails.Builder> getGeoLocationDetailsList() {
            List<GeoLocationDetails.Builder> result = GeoLocationDetailsListCopier.copyToBuilder(this.geoLocationDetailsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeoLocationDetailsList(Collection<GeoLocationDetails.BuilderImpl> geoLocationDetailsList) {
            this.geoLocationDetailsList = GeoLocationDetailsListCopier.copyFromBuilder(geoLocationDetailsList);
        }

        @Override
        public final Builder geoLocationDetailsList(Collection<GeoLocationDetails> geoLocationDetailsList) {
            this.geoLocationDetailsList = GeoLocationDetailsListCopier.copy(geoLocationDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoLocationDetailsList(GeoLocationDetails ... geoLocationDetailsList) {
            this.geoLocationDetailsList(Arrays.asList(geoLocationDetailsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoLocationDetailsList(Consumer<GeoLocationDetails.Builder> ... geoLocationDetailsList) {
            this.geoLocationDetailsList(Stream.of(geoLocationDetailsList).map(c -> (GeoLocationDetails)((GeoLocationDetails.Builder)GeoLocationDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getNextContinentCode() {
            return this.nextContinentCode;
        }

        public final void setNextContinentCode(String nextContinentCode) {
            this.nextContinentCode = nextContinentCode;
        }

        @Override
        public final Builder nextContinentCode(String nextContinentCode) {
            this.nextContinentCode = nextContinentCode;
            return this;
        }

        public final String getNextCountryCode() {
            return this.nextCountryCode;
        }

        public final void setNextCountryCode(String nextCountryCode) {
            this.nextCountryCode = nextCountryCode;
        }

        @Override
        public final Builder nextCountryCode(String nextCountryCode) {
            this.nextCountryCode = nextCountryCode;
            return this;
        }

        public final String getNextSubdivisionCode() {
            return this.nextSubdivisionCode;
        }

        public final void setNextSubdivisionCode(String nextSubdivisionCode) {
            this.nextSubdivisionCode = nextSubdivisionCode;
        }

        @Override
        public final Builder nextSubdivisionCode(String nextSubdivisionCode) {
            this.nextSubdivisionCode = nextSubdivisionCode;
            return this;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public ListGeoLocationsResponse build() {
            return new ListGeoLocationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGeoLocationsResponse> {
        public Builder geoLocationDetailsList(Collection<GeoLocationDetails> var1);

        public Builder geoLocationDetailsList(GeoLocationDetails ... var1);

        public Builder geoLocationDetailsList(Consumer<GeoLocationDetails.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextContinentCode(String var1);

        public Builder nextCountryCode(String var1);

        public Builder nextSubdivisionCode(String var1);

        public Builder maxItems(String var1);
    }
}

