/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.services.route53.model.TrafficPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrafficPolicyVersionResponse
extends Route53Response
implements ToCopyableBuilder<Builder, CreateTrafficPolicyVersionResponse> {
    private static final SdkField<TrafficPolicy> TRAFFIC_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrafficPolicy").getter(CreateTrafficPolicyVersionResponse.getter(CreateTrafficPolicyVersionResponse::trafficPolicy)).setter(CreateTrafficPolicyVersionResponse.setter(Builder::trafficPolicy)).constructor(TrafficPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicy").unmarshallLocationName("TrafficPolicy").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(CreateTrafficPolicyVersionResponse.getter(CreateTrafficPolicyVersionResponse::location)).setter(CreateTrafficPolicyVersionResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location").unmarshallLocationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_POLICY_FIELD, LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTrafficPolicyVersionResponse.memberNameToFieldInitializer();
    private final TrafficPolicy trafficPolicy;
    private final String location;

    private CreateTrafficPolicyVersionResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicy = builder.trafficPolicy;
        this.location = builder.location;
    }

    public final TrafficPolicy trafficPolicy() {
        return this.trafficPolicy;
    }

    public final String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyVersionResponse)) {
            return false;
        }
        CreateTrafficPolicyVersionResponse other = (CreateTrafficPolicyVersionResponse)((Object)obj);
        return Objects.equals(this.trafficPolicy(), other.trafficPolicy()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrafficPolicyVersionResponse").add("TrafficPolicy", (Object)this.trafficPolicy()).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficPolicy": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicy()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrafficPolicy", TRAFFIC_POLICY_FIELD);
        map.put("Location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficPolicyVersionResponse, T> g) {
        return obj -> g.apply((CreateTrafficPolicyVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private TrafficPolicy trafficPolicy;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficPolicyVersionResponse model) {
            super(model);
            this.trafficPolicy(model.trafficPolicy);
            this.location(model.location);
        }

        public final TrafficPolicy.Builder getTrafficPolicy() {
            return this.trafficPolicy != null ? this.trafficPolicy.toBuilder() : null;
        }

        public final void setTrafficPolicy(TrafficPolicy.BuilderImpl trafficPolicy) {
            this.trafficPolicy = trafficPolicy != null ? trafficPolicy.build() : null;
        }

        @Override
        public final Builder trafficPolicy(TrafficPolicy trafficPolicy) {
            this.trafficPolicy = trafficPolicy;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public CreateTrafficPolicyVersionResponse build() {
            return new CreateTrafficPolicyVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrafficPolicyVersionResponse> {
        public Builder trafficPolicy(TrafficPolicy var1);

        default public Builder trafficPolicy(Consumer<TrafficPolicy.Builder> trafficPolicy) {
            return this.trafficPolicy((TrafficPolicy)((TrafficPolicy.Builder)TrafficPolicy.builder().applyMutation(trafficPolicy)).build());
        }

        public Builder location(String var1);
    }
}

