/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.LocationSummariesCopier;
import software.amazon.awssdk.services.route53.model.LocationSummary;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCidrLocationsResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListCidrLocationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCidrLocationsResponse.getter(ListCidrLocationsResponse::nextToken)).setter(ListCidrLocationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<List<LocationSummary>> CIDR_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrLocations").getter(ListCidrLocationsResponse.getter(ListCidrLocationsResponse::cidrLocations)).setter(ListCidrLocationsResponse.setter(Builder::cidrLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrLocations").unmarshallLocationName("CidrLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CIDR_LOCATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCidrLocationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<LocationSummary> cidrLocations;

    private ListCidrLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.cidrLocations = builder.cidrLocations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCidrLocations() {
        return this.cidrLocations != null && !(this.cidrLocations instanceof SdkAutoConstructList);
    }

    public final List<LocationSummary> cidrLocations() {
        return this.cidrLocations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrLocations() ? this.cidrLocations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCidrLocationsResponse)) {
            return false;
        }
        ListCidrLocationsResponse other = (ListCidrLocationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCidrLocations() == other.hasCidrLocations() && Objects.equals(this.cidrLocations(), other.cidrLocations());
    }

    public final String toString() {
        return ToString.builder((String)"ListCidrLocationsResponse").add("NextToken", (Object)this.nextToken()).add("CidrLocations", this.hasCidrLocations() ? this.cidrLocations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CidrLocations": {
                return Optional.ofNullable(clazz.cast(this.cidrLocations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("CidrLocations", CIDR_LOCATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCidrLocationsResponse, T> g) {
        return obj -> g.apply((ListCidrLocationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<LocationSummary> cidrLocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCidrLocationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.cidrLocations(model.cidrLocations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<LocationSummary.Builder> getCidrLocations() {
            List<LocationSummary.Builder> result = LocationSummariesCopier.copyToBuilder(this.cidrLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCidrLocations(Collection<LocationSummary.BuilderImpl> cidrLocations) {
            this.cidrLocations = LocationSummariesCopier.copyFromBuilder(cidrLocations);
        }

        @Override
        public final Builder cidrLocations(Collection<LocationSummary> cidrLocations) {
            this.cidrLocations = LocationSummariesCopier.copy(cidrLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrLocations(LocationSummary ... cidrLocations) {
            this.cidrLocations(Arrays.asList(cidrLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrLocations(Consumer<LocationSummary.Builder> ... cidrLocations) {
            this.cidrLocations(Stream.of(cidrLocations).map(c -> (LocationSummary)((LocationSummary.Builder)LocationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCidrLocationsResponse build() {
            return new ListCidrLocationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCidrLocationsResponse> {
        public Builder nextToken(String var1);

        public Builder cidrLocations(Collection<LocationSummary> var1);

        public Builder cidrLocations(LocationSummary ... var1);

        public Builder cidrLocations(Consumer<LocationSummary.Builder> ... var1);
    }
}

