/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to retrieve a list of the health checks that are associated with the current Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHealthChecksRequest extends Route53Request implements
        ToCopyableBuilder<ListHealthChecksRequest.Builder, ListHealthChecksRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(ListHealthChecksRequest::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker")
                    .unmarshallLocationName("marker").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListHealthChecksRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxitems")
                    .unmarshallLocationName("maxitems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(MARKER_FIELD, MAX_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final String maxItems;

    private ListHealthChecksRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more health
     * checks. To get another group, submit another <code>ListHealthChecks</code> request.
     * </p>
     * <p>
     * For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
     * which is the ID of the first health check that Amazon Route 53 will return if you submit another request.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * health checks to get.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         health checks. To get another group, submit another <code>ListHealthChecks</code> request. </p>
     *         <p>
     *         For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous
     *         response, which is the ID of the first health check that Amazon Route 53 will return if you submit
     *         another request.
     *         </p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more health checks to get.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to the
     * current request. Amazon Route 53 returns a maximum of 1000 items. If you set <code>MaxItems</code> to a value
     * greater than 1000, Route 53 returns only the first 1000 health checks.
     * </p>
     * 
     * @return The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to
     *         the current request. Amazon Route 53 returns a maximum of 1000 items. If you set <code>MaxItems</code> to
     *         a value greater than 1000, Route 53 returns only the first 1000 health checks.
     */
    public final String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHealthChecksRequest)) {
            return false;
        }
        ListHealthChecksRequest other = (ListHealthChecksRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHealthChecksRequest").add("Marker", marker()).add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("marker", MARKER_FIELD);
        map.put("maxitems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListHealthChecksRequest, T> g) {
        return obj -> g.apply((ListHealthChecksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, ListHealthChecksRequest> {
        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more health
         * checks. To get another group, submit another <code>ListHealthChecks</code> request.
         * </p>
         * <p>
         * For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous
         * response, which is the ID of the first health check that Amazon Route 53 will return if you submit another
         * request.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * health checks to get.
         * </p>
         * 
         * @param marker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        health checks. To get another group, submit another <code>ListHealthChecks</code> request. </p>
         *        <p>
         *        For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous
         *        response, which is the ID of the first health check that Amazon Route 53 will return if you submit
         *        another request.
         *        </p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more health checks to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to the
         * current request. Amazon Route 53 returns a maximum of 1000 items. If you set <code>MaxItems</code> to a value
         * greater than 1000, Route 53 returns only the first 1000 health checks.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response
         *        to the current request. Amazon Route 53 returns a maximum of 1000 items. If you set
         *        <code>MaxItems</code> to a value greater than 1000, Route 53 returns only the first 1000 health
         *        checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String marker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHealthChecksRequest model) {
            super(model);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListHealthChecksRequest build() {
            return new ListHealthChecksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
