/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information for a change request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeBatch implements SdkPojo, Serializable, ToCopyableBuilder<ChangeBatch.Builder, ChangeBatch> {
    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(ChangeBatch::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final SdkField<List<Change>> CHANGES_FIELD = SdkField
            .<List<Change>> builder(MarshallingType.LIST)
            .memberName("Changes")
            .getter(getter(ChangeBatch::changes))
            .setter(setter(Builder::changes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Changes")
                    .unmarshallLocationName("Changes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Change")
                            .memberFieldInfo(
                                    SdkField.<Change> builder(MarshallingType.SDK_POJO)
                                            .constructor(Change::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Change").unmarshallLocationName("Change").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, CHANGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String comment;

    private final List<Change> changes;

    private ChangeBatch(BuilderImpl builder) {
        this.comment = builder.comment;
        this.changes = builder.changes;
    }

    /**
     * <p>
     * <i>Optional:</i> Any comments you want to include about a change batch request.
     * </p>
     * 
     * @return <i>Optional:</i> Any comments you want to include about a change batch request.
     */
    public final String comment() {
        return comment;
    }

    /**
     * For responses, this returns true if the service returned a value for the Changes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChanges() {
        return changes != null && !(changes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the changes to make to the record sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChanges} method.
     * </p>
     * 
     * @return Information about the changes to make to the record sets.
     */
    public final List<Change> changes() {
        return changes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(hasChanges() ? changes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeBatch)) {
            return false;
        }
        ChangeBatch other = (ChangeBatch) obj;
        return Objects.equals(comment(), other.comment()) && hasChanges() == other.hasChanges()
                && Objects.equals(changes(), other.changes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeBatch").add("Comment", comment()).add("Changes", hasChanges() ? changes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "Changes":
            return Optional.ofNullable(clazz.cast(changes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Comment", COMMENT_FIELD);
        map.put("Changes", CHANGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeBatch, T> g) {
        return obj -> g.apply((ChangeBatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeBatch> {
        /**
         * <p>
         * <i>Optional:</i> Any comments you want to include about a change batch request.
         * </p>
         * 
         * @param comment
         *        <i>Optional:</i> Any comments you want to include about a change batch request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * Information about the changes to make to the record sets.
         * </p>
         * 
         * @param changes
         *        Information about the changes to make to the record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changes(Collection<Change> changes);

        /**
         * <p>
         * Information about the changes to make to the record sets.
         * </p>
         * 
         * @param changes
         *        Information about the changes to make to the record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changes(Change... changes);

        /**
         * <p>
         * Information about the changes to make to the record sets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53.model.Change.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.route53.model.Change#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53.model.Change.Builder#build()} is called immediately and its
         * result is passed to {@link #changes(List<Change>)}.
         * 
         * @param changes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53.model.Change.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changes(java.util.Collection<Change>)
         */
        Builder changes(Consumer<Change.Builder>... changes);
    }

    static final class BuilderImpl implements Builder {
        private String comment;

        private List<Change> changes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeBatch model) {
            comment(model.comment);
            changes(model.changes);
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final List<Change.Builder> getChanges() {
            List<Change.Builder> result = ChangesCopier.copyToBuilder(this.changes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChanges(Collection<Change.BuilderImpl> changes) {
            this.changes = ChangesCopier.copyFromBuilder(changes);
        }

        @Override
        public final Builder changes(Collection<Change> changes) {
            this.changes = ChangesCopier.copy(changes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Change... changes) {
            changes(Arrays.asList(changes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Consumer<Change.Builder>... changes) {
            changes(Stream.of(changes).map(c -> Change.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ChangeBatch build() {
            return new ChangeBatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
