/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.CidrCollection;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCidrCollectionResponse
extends Route53Response
implements ToCopyableBuilder<Builder, CreateCidrCollectionResponse> {
    private static final SdkField<CidrCollection> COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Collection").getter(CreateCidrCollectionResponse.getter(CreateCidrCollectionResponse::collection)).setter(CreateCidrCollectionResponse.setter(Builder::collection)).constructor(CidrCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Collection").unmarshallLocationName("Collection").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(CreateCidrCollectionResponse.getter(CreateCidrCollectionResponse::location)).setter(CreateCidrCollectionResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location").unmarshallLocationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_FIELD, LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCidrCollectionResponse.memberNameToFieldInitializer();
    private final CidrCollection collection;
    private final String location;

    private CreateCidrCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.collection = builder.collection;
        this.location = builder.location;
    }

    public final CidrCollection collection() {
        return this.collection;
    }

    public final String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collection());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCidrCollectionResponse)) {
            return false;
        }
        CreateCidrCollectionResponse other = (CreateCidrCollectionResponse)((Object)obj);
        return Objects.equals(this.collection(), other.collection()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCidrCollectionResponse").add("Collection", (Object)this.collection()).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Collection": {
                return Optional.ofNullable(clazz.cast(this.collection()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Collection", COLLECTION_FIELD);
        map.put("Location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCidrCollectionResponse, T> g) {
        return obj -> g.apply((CreateCidrCollectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private CidrCollection collection;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCidrCollectionResponse model) {
            super(model);
            this.collection(model.collection);
            this.location(model.location);
        }

        public final CidrCollection.Builder getCollection() {
            return this.collection != null ? this.collection.toBuilder() : null;
        }

        public final void setCollection(CidrCollection.BuilderImpl collection) {
            this.collection = collection != null ? collection.build() : null;
        }

        @Override
        public final Builder collection(CidrCollection collection) {
            this.collection = collection;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public CreateCidrCollectionResponse build() {
            return new CreateCidrCollectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCidrCollectionResponse> {
        public Builder collection(CidrCollection var1);

        default public Builder collection(Consumer<CidrCollection.Builder> collection) {
            return this.collection((CidrCollection)((CidrCollection.Builder)CidrCollection.builder().applyMutation(collection)).build());
        }

        public Builder location(String var1);
    }
}

